/*
 * Decompiled with CFR 0.152.
 */
package liedge.limacore.client.gui;

import com.google.common.base.Preconditions;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import liedge.limacore.capability.fluid.LimaFluidUtil;
import liedge.limacore.lib.LimaColor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;
import org.joml.Matrix4f;

public final class LimaGuiUtil {
    public static final int FONT_HALF_LINE_HEIGHT = 5;

    private LimaGuiUtil() {
    }

    public static boolean isMouseWithinXYBounds(double mouseX, double mouseY, int x1, int y1, int x2, int y2) {
        return mouseX >= (double)x1 && mouseY >= (double)y1 && mouseX < (double)x2 && mouseY < (double)y2;
    }

    public static boolean isMouseWithinArea(double mouseX, double mouseY, int x, int y, int width, int height) {
        return LimaGuiUtil.isMouseWithinXYBounds(mouseX, mouseY, x, y, x + width, y + height);
    }

    public static int halfTextWidth(String text) {
        return Math.ceilDiv(Minecraft.getInstance().font.width(text), 2);
    }

    public static int halfTextWidth(FormattedText text) {
        return Math.ceilDiv(Minecraft.getInstance().font.width(text), 2);
    }

    public static void directBlit(GuiGraphics graphics, ResourceLocation atlasLocation, float x1, float y1, float x2, float y2, int zOffset, float u0, float u1, float v0, float v1) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)atlasLocation);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        Matrix4f mx4 = graphics.pose().last().pose();
        BufferBuilder buffer = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        buffer.addVertex(mx4, x1, y1, (float)zOffset).setUv(u0, v0);
        buffer.addVertex(mx4, x1, y2, (float)zOffset).setUv(u0, v1);
        buffer.addVertex(mx4, x2, y2, (float)zOffset).setUv(u1, v1);
        buffer.addVertex(mx4, x2, y1, (float)zOffset).setUv(u1, v0);
        BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
    }

    public static void directBlit(GuiGraphics graphics, ResourceLocation atlasLocation, float x1, float y1, float x2, float y2, float u0, float u1, float v0, float v1) {
        LimaGuiUtil.directBlit(graphics, atlasLocation, x1, y1, x2, y2, 0, u0, u1, v0, v1);
    }

    public static void directBlit(GuiGraphics graphics, float x, float y, int width, int height, TextureAtlasSprite sprite) {
        LimaGuiUtil.directBlit(graphics, sprite.atlasLocation(), x, y, x + (float)width, y + (float)height, 0, sprite.getU0(), sprite.getU1(), sprite.getV0(), sprite.getV1());
    }

    public static void directColorBlit(GuiGraphics graphics, ResourceLocation atlasLocation, float x1, float y1, float x2, float y2, int zOffset, float u0, float u1, float v0, float v1, float red, float green, float blue, float alpha) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)atlasLocation);
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        RenderSystem.enableBlend();
        Matrix4f mx4 = graphics.pose().last().pose();
        BufferBuilder buffer = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        buffer.addVertex(mx4, x1, y1, (float)zOffset).setUv(u0, v0).setColor(red, green, blue, alpha);
        buffer.addVertex(mx4, x1, y2, (float)zOffset).setUv(u0, v1).setColor(red, green, blue, alpha);
        buffer.addVertex(mx4, x2, y2, (float)zOffset).setUv(u1, v1).setColor(red, green, blue, alpha);
        buffer.addVertex(mx4, x2, y1, (float)zOffset).setUv(u1, v0).setColor(red, green, blue, alpha);
        BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
        RenderSystem.disableBlend();
    }

    public static void directColorBlit(GuiGraphics graphics, float x, float y, int width, int height, float red, float green, float blue, float alpha, TextureAtlasSprite sprite) {
        LimaGuiUtil.directColorBlit(graphics, sprite.atlasLocation(), x, y, x + (float)width, y + (float)height, 0, sprite.getU0(), sprite.getU1(), sprite.getV0(), sprite.getV1(), red, green, blue, alpha);
    }

    public static void directColorBlit(GuiGraphics graphics, float x, float y, int width, int height, LimaColor color, float alpha, TextureAtlasSprite sprite) {
        LimaGuiUtil.directColorBlit(graphics, x, y, width, height, color.red(), color.green(), color.blue(), alpha, sprite);
    }

    public static void partialHorizontalBlit(GuiGraphics graphics, float x, float y, int width, int height, float percentage, TextureAtlasSprite sprite) {
        float partialWidth = (float)width * percentage;
        LimaGuiUtil.directBlit(graphics, sprite.atlasLocation(), x, y, x + partialWidth, y + (float)height, 0, sprite.getU0(), sprite.getU(percentage), sprite.getV0(), sprite.getV1());
    }

    public static void partialVerticalBlit(GuiGraphics graphics, float x, float y, int width, int height, float percentage, TextureAtlasSprite sprite) {
        float partialHeight = (float)height * percentage;
        LimaGuiUtil.directBlit(graphics, sprite.atlasLocation(), x, y += (float)height - partialHeight, x + (float)width, y + partialHeight, 0, sprite.getU0(), sprite.getU1(), sprite.getV(1.0f - percentage), sprite.getV1());
    }

    public static void nineSliceBlit(GuiGraphics graphics, ResourceLocation textureLocation, int cornerSize, int x, int y, int width, int height, int textureWidth, int textureHeight) {
        int minSize = cornerSize * 2 + 1;
        Preconditions.checkArgument((width >= minSize && height >= minSize ? 1 : 0) != 0, (Object)"Nine-slice dimensions too small");
        if (width == textureWidth && height == textureHeight) {
            graphics.blit(textureLocation, x, y, 0.0f, 0.0f, width, height, textureWidth, textureHeight);
            return;
        }
        int uOffset = textureHeight - cornerSize;
        int vOffset = textureWidth - cornerSize;
        int cornerX2 = x + width - cornerSize;
        int cornerY2 = y + height - cornerSize;
        graphics.blit(textureLocation, x, y, 0.0f, 0.0f, cornerSize, cornerSize, textureWidth, textureHeight);
        graphics.blit(textureLocation, cornerX2, y, (float)uOffset, 0.0f, cornerSize, cornerSize, textureWidth, textureHeight);
        graphics.blit(textureLocation, x, cornerY2, 0.0f, (float)vOffset, cornerSize, cornerSize, textureWidth, textureHeight);
        graphics.blit(textureLocation, cornerX2, cornerY2, (float)uOffset, (float)vOffset, cornerSize, cornerSize, textureWidth, textureHeight);
        int borderWidth = width - cornerSize * 2;
        graphics.blit(textureLocation, x + cornerSize, y, borderWidth, cornerSize, (float)cornerSize, 0.0f, 1, cornerSize, textureWidth, textureHeight);
        graphics.blit(textureLocation, x + cornerSize, cornerY2, borderWidth, cornerSize, (float)cornerSize, (float)vOffset, 1, cornerSize, textureWidth, textureHeight);
        int borderHeight = height - cornerSize * 2;
        graphics.blit(textureLocation, x, y + cornerSize, cornerSize, borderHeight, 0.0f, (float)cornerSize, cornerSize, 1, textureWidth, textureHeight);
        graphics.blit(textureLocation, cornerX2, y + cornerSize, cornerSize, borderHeight, (float)uOffset, (float)cornerSize, cornerSize, 1, textureWidth, textureHeight);
        graphics.blit(textureLocation, x + cornerSize, y + cornerSize, borderWidth, borderHeight, (float)cornerSize, (float)cornerSize, 1, 1, textureWidth, textureHeight);
    }

    public static void nineSliceNoBottomBlit(GuiGraphics graphics, ResourceLocation textureLocation, int cornerSize, int x, int y, int width, int height, int textureWidth, int textureHeight) {
        Preconditions.checkArgument((width >= cornerSize * 2 + 1 && height >= cornerSize + 1 ? 1 : 0) != 0, (Object)"Nine-slice dimensions too small");
        int uOffset = textureHeight - cornerSize;
        int cornerX2 = x + width - cornerSize;
        graphics.blit(textureLocation, x, y, 0.0f, 0.0f, cornerSize, cornerSize, textureWidth, textureHeight);
        graphics.blit(textureLocation, cornerX2, y, (float)uOffset, 0.0f, cornerSize, cornerSize, textureWidth, textureHeight);
        int borderWidth = width - cornerSize * 2;
        graphics.blit(textureLocation, x + cornerSize, y, borderWidth, cornerSize, (float)cornerSize, 0.0f, 1, cornerSize, textureWidth, textureHeight);
        int borderHeight = height - cornerSize;
        graphics.blit(textureLocation, x, y + cornerSize, cornerSize, borderHeight, 0.0f, (float)cornerSize, cornerSize, 1, textureWidth, textureHeight);
        graphics.blit(textureLocation, cornerX2, y + cornerSize, cornerSize, borderHeight, (float)uOffset, (float)cornerSize, cornerSize, 1, textureWidth, textureHeight);
        graphics.blit(textureLocation, x + cornerSize, y + cornerSize, borderWidth, borderHeight, (float)cornerSize, (float)cornerSize, 1, 1, textureWidth, textureHeight);
    }

    public static void renderFluid(GuiGraphics graphics, FluidStack stack, int x, int y) {
        TextureAtlasSprite sprite;
        IClientFluidTypeExtensions clientFluid = IClientFluidTypeExtensions.of((Fluid)stack.getFluid());
        ResourceLocation stillSpriteLoc = clientFluid.getStillTexture(stack);
        if (stillSpriteLoc != null && (sprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(stillSpriteLoc)).atlasLocation() != MissingTextureAtlasSprite.getLocation()) {
            int tint = clientFluid.getTintColor(stack);
            float red = (float)FastColor.ARGB32.red((int)tint) / 255.0f;
            float green = (float)FastColor.ARGB32.green((int)tint) / 255.0f;
            float blue = (float)FastColor.ARGB32.blue((int)tint) / 255.0f;
            graphics.blit(x, y, 0, 16, 16, sprite, red, green, blue, 1.0f);
        }
    }

    public static void renderFluidWithAmount(GuiGraphics graphics, FluidStack stack, int x, int y) {
        if (!stack.isEmpty()) {
            LimaGuiUtil.renderFluid(graphics, stack, x, y);
            PoseStack poseStack = graphics.pose();
            poseStack.pushPose();
            String amountText = LimaFluidUtil.formatCompactFluidAmount(stack.getAmount());
            int textWidth = LimaGuiUtil.halfTextWidth(amountText);
            poseStack.translate((float)(x + 16 - textWidth), (float)(y + 16 - 5), 2.0f);
            poseStack.scale(0.5f, 0.5f, 1.0f);
            graphics.drawString(Minecraft.getInstance().font, amountText, 0, 0, -1, true);
            poseStack.popPose();
        }
    }
}

