/*
 * Decompiled with CFR 0.152.
 */
package liedge.limacore.client.model.baked;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import java.util.List;
import liedge.limacore.client.model.baked.ItemLayerBakedModel;
import liedge.limacore.lib.LimaColor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.RenderTypeGroup;
import net.neoforged.neoforge.client.model.BakedModelWrapper;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BakedItemLayer
extends BakedModelWrapper<BakedModel> {
    private final List<BakedQuad> quads;
    private final List<BakedModel> self;
    private final RenderType renderType;
    private final RenderType fabulousRenderType;
    private final List<RenderType> renderTypes;
    private final List<RenderType> fabulousRenderTypes;

    public static Builder builder(String name) {
        return new Builder(name);
    }

    public BakedItemLayer(BakedModel parent, List<BakedQuad> quads, @Nullable RenderType renderType, @Nullable RenderType fabulousRenderType) {
        super(parent);
        this.quads = quads;
        this.self = List.of(this);
        this.renderType = renderType != null ? renderType : Sheets.translucentItemSheet();
        this.fabulousRenderType = fabulousRenderType != null ? renderType : Sheets.translucentCullBlockSheet();
        this.renderTypes = List.of(this.renderType);
        this.fabulousRenderTypes = List.of(this.fabulousRenderType);
    }

    public BakedItemLayer(BakedModel parent, List<BakedQuad> quads, RenderTypeGroup renderTypeGroup) {
        this(parent, quads, renderTypeGroup.entity(), renderTypeGroup.entityFabulous());
    }

    public List<BakedQuad> getQuads() {
        return this.quads;
    }

    public void putQuadsInBuffer(PoseStack poseStack, MultiBufferSource bufferSource, float red, float green, float blue, int packedLight) {
        RenderType renderType = Minecraft.useShaderTransparency() ? this.renderType : this.fabulousRenderType;
        VertexConsumer buffer = bufferSource.getBuffer(renderType);
        PoseStack.Pose pose = poseStack.last();
        for (BakedQuad quad : this.quads) {
            buffer.putBulkData(pose, quad, red, green, blue, 1.0f, packedLight, OverlayTexture.NO_OVERLAY);
        }
    }

    public void putQuadsInBuffer(PoseStack poseStack, MultiBufferSource bufferSource, LimaColor tint, int packedLight) {
        this.putQuadsInBuffer(poseStack, bufferSource, tint.red(), tint.green(), tint.blue(), packedLight);
    }

    public void putQuadsInBuffer(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        this.putQuadsInBuffer(poseStack, bufferSource, 1.0f, 1.0f, 1.0f, packedLight);
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource rand) {
        return side == null ? this.quads : List.of();
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand, @NotNull ModelData extraData, @Nullable RenderType renderType) {
        return side == null ? this.quads : List.of();
    }

    public List<RenderType> getRenderTypes(ItemStack itemStack, boolean fabulous) {
        return fabulous ? this.fabulousRenderTypes : this.renderTypes;
    }

    public List<BakedModel> getRenderPasses(ItemStack itemStack, boolean fabulous) {
        return this.self;
    }

    public ItemOverrides getOverrides() {
        return ItemOverrides.EMPTY;
    }

    public boolean isCustomRenderer() {
        return false;
    }

    public static final class Builder {
        private final String name;
        private final ObjectList<BakedQuad> quads;
        private RenderTypeGroup renderTypeGroup = RenderTypeGroup.EMPTY;

        private Builder(String name) {
            this.name = name;
            this.quads = new ObjectArrayList();
        }

        public String getName() {
            return this.name;
        }

        public void addQuad(BakedQuad quad) {
            this.quads.add((Object)quad);
        }

        public void setRenderTypes(RenderTypeGroup renderTypes) {
            this.renderTypeGroup = renderTypes;
        }

        public BakedItemLayer build(ItemLayerBakedModel parent) {
            return new BakedItemLayer((BakedModel)parent, (List<BakedQuad>)ObjectLists.unmodifiable(this.quads), this.renderTypeGroup);
        }
    }
}

