/*
 * Decompiled with CFR 0.152.
 */
package liedge.limacore.client.model.baked;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.Direction;
import org.jetbrains.annotations.Nullable;

public record BlockQuadsGroup(Map<Direction, List<BakedQuad>> culledFaces, List<BakedQuad> unculledFaces) {
    public static Builder builder() {
        return new Builder();
    }

    public List<BakedQuad> getQuads(@Nullable Direction side) {
        return side == null ? this.unculledFaces : this.culledFaces.get(side);
    }

    public static final class Builder {
        private final Map<Direction, ObjectList<BakedQuad>> culledFaces = new EnumMap<Direction, ObjectList<BakedQuad>>(Direction.class);
        private final ObjectList<BakedQuad> unculledFaces = new ObjectArrayList();

        private Builder() {
        }

        public BlockQuadsGroup build() {
            EnumMap<Direction, List<BakedQuad>> culled = new EnumMap<Direction, List<BakedQuad>>(Direction.class);
            for (Direction side : Direction.values()) {
                if (this.culledFaces.containsKey(side) && !this.culledFaces.get(side).isEmpty()) {
                    culled.put(side, (List<BakedQuad>)ObjectLists.unmodifiable(this.culledFaces.get(side)));
                    continue;
                }
                culled.put(side, List.of());
            }
            return new BlockQuadsGroup(culled, (List<BakedQuad>)ObjectLists.unmodifiable(this.unculledFaces));
        }

        public void addQuad(@Nullable Direction side, BakedQuad quad) {
            if (side != null) {
                this.getOrCreateFaceList(side).add(quad);
            } else {
                this.unculledFaces.add((Object)quad);
            }
        }

        public void copyBuilderData(Builder other) {
            this.unculledFaces.addAll(other.unculledFaces);
            for (Direction side : other.culledFaces.keySet()) {
                this.getOrCreateFaceList(side).addAll((Collection)other.culledFaces.get(side));
            }
        }

        private List<BakedQuad> getOrCreateFaceList(Direction side) {
            return (List)this.culledFaces.computeIfAbsent(side, $ -> new ObjectArrayList());
        }
    }
}

