/*
 * Decompiled with CFR 0.152.
 */
package liedge.limacore.client.model.geometry;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import liedge.limacore.LimaCore;
import liedge.limacore.client.model.baked.BlockLayerBakedModel;
import liedge.limacore.client.model.baked.BlockQuadsGroup;
import liedge.limacore.client.model.geometry.ElementGroupGeometry;
import liedge.limacore.client.model.geometry.GeometryLayerDefinition;
import liedge.limacore.client.model.geometry.LimaGeometryLoader;
import liedge.limacore.util.LimaCollectionsUtil;
import liedge.limacore.util.LimaJsonUtil;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.neoforged.neoforge.client.RenderTypeGroup;
import net.neoforged.neoforge.client.model.ExtraFaceData;
import net.neoforged.neoforge.client.model.QuadTransformers;
import net.neoforged.neoforge.client.model.geometry.IGeometryBakingContext;

public class BlockLayerGeometry
extends ElementGroupGeometry {
    public static final ResourceLocation LOADER_ID = LimaCore.RESOURCES.location("block_layers");
    public static final LimaGeometryLoader<?> LOADER = new Loader();
    private final List<GeometryLayerDefinition> layerDefinitions;

    private BlockLayerGeometry(List<BlockElement> elements, Map<String, IntList> elementGroups, List<GeometryLayerDefinition> layerDefinitions) {
        super(elements, elementGroups);
        this.layerDefinitions = layerDefinitions;
    }

    @Override
    protected BakedModel bake(IGeometryBakingContext context, ModelBaker baker, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ItemOverrides overrides, TextureAtlasSprite particleIcon, RenderTypeGroup modelRenderTypes, List<BlockElement> elements, Map<String, IntList> elementGroups) {
        BlockQuadsGroup.Builder masterBuilder = BlockQuadsGroup.builder();
        Object2ObjectOpenHashMap builders = new Object2ObjectOpenHashMap();
        ObjectArrayList normalItemQuads = new ObjectArrayList();
        ObjectArrayList emissiveItemQuads = new ObjectArrayList();
        for (GeometryLayerDefinition definition : this.layerDefinitions) {
            RenderTypeGroup rtg = definition.renderTypeName() != null ? this.getRenderTypes(context, definition.renderTypeName()) : modelRenderTypes;
            RenderType layerRenderType = rtg.isEmpty() ? RenderType.SOLID : rtg.block();
            BlockQuadsGroup.Builder builder = builders.computeIfAbsent(layerRenderType, $ -> BlockQuadsGroup.builder());
            IntList elementList = LimaCollectionsUtil.toIntList(definition.groups().stream().flatMapToInt(name -> ((IntList)elementGroups.get(name)).intStream()));
            IntListIterator intListIterator = elementList.iterator();
            while (intListIterator.hasNext()) {
                int elementIndex = (Integer)intListIterator.next();
                BlockElement element = elements.get(elementIndex);
                for (Direction side : element.faces.keySet()) {
                    BlockElementFace face = (BlockElementFace)element.faces.get(side);
                    TextureAtlasSprite sprite = spriteGetter.apply(context.getMaterial(face.texture()));
                    BakedQuad quad = BlockModel.bakeFace((BlockElement)element, (BlockElementFace)face, (TextureAtlasSprite)sprite, (Direction)side, (ModelState)modelState);
                    masterBuilder.addQuad(face.cullForDirection(), quad);
                    builder.addQuad(face.cullForDirection(), quad);
                    if (definition.hasEmissivity()) {
                        QuadTransformers.settingEmissivity((int)definition.emissivity()).processInPlace(quad);
                        emissiveItemQuads.add(quad);
                        continue;
                    }
                    normalItemQuads.add(quad);
                }
            }
        }
        return new BlockLayerBakedModel(context.useAmbientOcclusion(), context.isGui3d(), context.useBlockLight(), particleIcon, context.getTransforms(), overrides, (List<BakedQuad>)normalItemQuads, (List<BakedQuad>)emissiveItemQuads, masterBuilder, (Map<RenderType, BlockQuadsGroup.Builder>)builders);
    }

    private static class Loader
    extends ElementGroupGeometry.GeometryLoader {
        private Loader() {
        }

        @Override
        protected ElementGroupGeometry createGeometry(JsonObject rootJson, List<BlockElement> elements, Map<String, IntList> elementGroups) throws JsonParseException {
            JsonArray layersArray = GsonHelper.getAsJsonArray((JsonObject)rootJson, (String)"layers");
            ObjectArrayList layerDefinitions = new ObjectArrayList();
            for (JsonElement je : layersArray) {
                List<String> groups;
                JsonObject layerJson;
                if (je.isJsonObject()) {
                    layerJson = je.getAsJsonObject();
                    groups = LimaJsonUtil.stringsArrayStream(GsonHelper.getAsJsonArray((JsonObject)layerJson, (String)"groups")).filter(elementGroups::containsKey).toList();
                    int emissivity = GsonHelper.getAsInt((JsonObject)layerJson, (String)"emissivity", (int)0);
                    ResourceLocation rtn = layerJson.has("render_type") ? LimaJsonUtil.getAsResourceLocation(layerJson, "render_type") : null;
                    boolean disableShading = GsonHelper.getAsBoolean((JsonObject)layerJson, (String)"disable_shading", (emissivity > 0 ? 1 : 0) != 0);
                    if (disableShading) {
                        IntSet targetedElements = LimaCollectionsUtil.toIntSet(groups.stream().flatMapToInt(name -> ((IntList)elementGroups.get(name)).intStream()));
                        IntIterator intIterator = targetedElements.iterator();
                        while (intIterator.hasNext()) {
                            int elementIndex = (Integer)intIterator.next();
                            BlockElement element = elements.get(elementIndex);
                            ExtraFaceData faceData = Objects.requireNonNullElse(element.getFaceData(), ExtraFaceData.DEFAULT);
                            elements.set(elementIndex, new BlockElement(element.from, element.to, element.faces, element.rotation, false, faceData));
                        }
                    }
                    layerDefinitions.add(new GeometryLayerDefinition(null, groups, emissivity, rtn));
                    continue;
                }
                if (!je.isJsonArray()) continue;
                layerJson = je.getAsJsonArray();
                groups = LimaJsonUtil.stringsArrayStream((JsonArray)layerJson).filter(elementGroups::containsKey).toList();
                layerDefinitions.add(new GeometryLayerDefinition(null, groups, 0, null));
            }
            return new BlockLayerGeometry(elements, elementGroups, (List<GeometryLayerDefinition>)layerDefinitions);
        }

        @Override
        public ResourceLocation getLoaderId() {
            return LOADER_ID;
        }
    }
}

