/*
 * Decompiled with CFR 0.152.
 */
package liedge.limacore.client.model.geometry;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.math.Transformation;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import liedge.limacore.LimaCore;
import liedge.limacore.client.model.geometry.LimaGeometryLoader;
import liedge.limacore.client.renderer.LimaCoreRenderTypes;
import liedge.limacore.util.LimaJsonUtil;
import liedge.limacore.util.LimaStreamsUtil;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.neoforged.neoforge.client.RenderTypeGroup;
import net.neoforged.neoforge.client.model.geometry.IGeometryBakingContext;
import net.neoforged.neoforge.client.model.geometry.IUnbakedGeometry;
import net.neoforged.neoforge.client.model.geometry.UnbakedGeometryHelper;

public abstract class ElementGroupGeometry
implements IUnbakedGeometry<ElementGroupGeometry> {
    public static final String DEFAULT_GROUP_NAME = "group";
    public static final ResourceLocation CUSTOM_EMISSIVE_RENDER_TYPE_NAME = LimaCore.RESOURCES.location("custom_emissive");
    private final List<BlockElement> elements;
    private final Map<String, IntList> elementGroups;

    public static RenderTypeGroup customEmissiveRenderTypes() {
        return new RenderTypeGroup(RenderType.SOLID, LimaCoreRenderTypes.ITEM_POS_TEX_COLOR_SOLID);
    }

    protected ElementGroupGeometry(List<BlockElement> elements, Map<String, IntList> elementGroups) {
        this.elements = elements;
        this.elementGroups = elementGroups;
    }

    public BakedModel bake(IGeometryBakingContext context, ModelBaker baker, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ItemOverrides overrides) {
        TextureAtlasSprite particleIcon = spriteGetter.apply(context.getMaterial("particle"));
        ResourceLocation hint = context.getRenderTypeHint();
        RenderTypeGroup modelRenderTypes = hint != null ? context.getRenderType(hint) : RenderTypeGroup.EMPTY;
        Transformation rootTransform = context.getRootTransform();
        if (!rootTransform.isIdentity()) {
            modelState = UnbakedGeometryHelper.composeRootTransformIntoModelState((ModelState)modelState, (Transformation)rootTransform);
        }
        return this.bake(context, baker, spriteGetter, modelState, overrides, particleIcon, modelRenderTypes, this.elements, this.elementGroups);
    }

    protected RenderTypeGroup getRenderTypes(IGeometryBakingContext context, ResourceLocation name) {
        return name.equals((Object)CUSTOM_EMISSIVE_RENDER_TYPE_NAME) ? ElementGroupGeometry.customEmissiveRenderTypes() : context.getRenderType(name);
    }

    protected abstract BakedModel bake(IGeometryBakingContext var1, ModelBaker var2, Function<Material, TextureAtlasSprite> var3, ModelState var4, ItemOverrides var5, TextureAtlasSprite var6, RenderTypeGroup var7, List<BlockElement> var8, Map<String, IntList> var9);

    protected static abstract class GeometryLoader
    implements LimaGeometryLoader<ElementGroupGeometry> {
        protected GeometryLoader() {
        }

        public ElementGroupGeometry read(JsonObject rootJson, JsonDeserializationContext context) throws JsonParseException {
            Object2ObjectOpenHashMap elementGroups = new Object2ObjectOpenHashMap();
            IntArrayList defaultGroupElements = new IntArrayList();
            elementGroups.put((Object)ElementGroupGeometry.DEFAULT_GROUP_NAME, (Object)defaultGroupElements);
            ArrayDeque<JsonObject> queue = new ArrayDeque<JsonObject>();
            for (JsonElement je : GsonHelper.getAsJsonArray((JsonObject)rootJson, (String)"groups")) {
                if (je.isJsonObject()) {
                    queue.add(je.getAsJsonObject());
                    continue;
                }
                if (!je.isJsonPrimitive()) continue;
                defaultGroupElements.add(je.getAsInt());
            }
            JsonObject current = (JsonObject)queue.poll();
            while (current != null) {
                String name = GsonHelper.getAsString((JsonObject)current, (String)"name", (String)ElementGroupGeometry.DEFAULT_GROUP_NAME);
                IntList list = (IntList)elementGroups.computeIfAbsent((Object)name, $ -> new IntArrayList());
                for (JsonElement je : GsonHelper.getAsJsonArray((JsonObject)current, (String)"children")) {
                    if (je.isJsonObject()) {
                        queue.add(je.getAsJsonObject());
                        continue;
                    }
                    if (!je.isJsonPrimitive()) continue;
                    list.add(je.getAsInt());
                }
                current = (JsonObject)queue.poll();
            }
            elementGroups.object2ObjectEntrySet().removeIf(entry -> ((IntList)entry.getValue()).isEmpty());
            List elements = (List)LimaJsonUtil.mapArray(GsonHelper.getAsJsonArray((JsonObject)rootJson, (String)"elements"), context, BlockElement.class).collect(LimaStreamsUtil.toObjectList());
            return this.createGeometry(rootJson, elements, (Map<String, IntList>)elementGroups);
        }

        protected abstract ElementGroupGeometry createGeometry(JsonObject var1, List<BlockElement> var2, Map<String, IntList> var3) throws JsonParseException;
    }
}

