/*
 * Decompiled with CFR 0.152.
 */
package liedge.limacore.client.model.geometry;

import com.google.common.base.Strings;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import liedge.limacore.LimaCore;
import liedge.limacore.client.model.baked.BakedItemLayer;
import liedge.limacore.client.model.baked.ItemLayerBakedModel;
import liedge.limacore.client.model.geometry.ElementGroupGeometry;
import liedge.limacore.client.model.geometry.GeometryLayerDefinition;
import liedge.limacore.client.model.geometry.LimaGeometryLoader;
import liedge.limacore.util.LimaCollectionsUtil;
import liedge.limacore.util.LimaJsonUtil;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.neoforged.neoforge.client.RenderTypeGroup;
import net.neoforged.neoforge.client.model.QuadTransformers;
import net.neoforged.neoforge.client.model.geometry.IGeometryBakingContext;

public class ItemLayerGeometry
extends ElementGroupGeometry {
    public static final ResourceLocation LOADER_ID = LimaCore.RESOURCES.location("item_layers");
    public static final LimaGeometryLoader<?> LOADER = new Loader();
    private final List<GeometryLayerDefinition> layerDefinitions;
    private final boolean useCustomRenderer;

    private ItemLayerGeometry(List<BlockElement> elements, Map<String, IntList> elementGroups, List<GeometryLayerDefinition> layerDefinitions, boolean useCustomRenderer) {
        super(elements, elementGroups);
        this.layerDefinitions = layerDefinitions;
        this.useCustomRenderer = useCustomRenderer;
    }

    @Override
    protected BakedModel bake(IGeometryBakingContext context, ModelBaker baker, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ItemOverrides overrides, TextureAtlasSprite particleIcon, RenderTypeGroup modelRenderTypes, List<BlockElement> elements, Map<String, IntList> elementGroups) {
        ObjectOpenHashSet usedNames = new ObjectOpenHashSet();
        ObjectArrayList layerBuilders = new ObjectArrayList();
        for (GeometryLayerDefinition definition : this.layerDefinitions) {
            if (Strings.isNullOrEmpty((String)definition.name())) {
                throw new IllegalStateException("Layer name cannot be missing or empty.");
            }
            if (!usedNames.add(definition.name())) {
                throw new IllegalStateException("Duplicate layer name: " + definition.name());
            }
            BakedItemLayer.Builder layerBuilder = BakedItemLayer.builder(definition.name());
            layerBuilders.add(layerBuilder);
            IntList elementList = LimaCollectionsUtil.toIntList(definition.groups().stream().flatMapToInt(o -> ((IntList)elementGroups.get(o)).intStream()));
            IntListIterator intListIterator = elementList.iterator();
            while (intListIterator.hasNext()) {
                int elementIndex = (Integer)intListIterator.next();
                BlockElement element = elements.get(elementIndex);
                for (Direction side : element.faces.keySet()) {
                    BlockElementFace face = (BlockElementFace)element.faces.get(side);
                    TextureAtlasSprite sprite = spriteGetter.apply(context.getMaterial(face.texture()));
                    BakedQuad quad = BlockModel.bakeFace((BlockElement)element, (BlockElementFace)face, (TextureAtlasSprite)sprite, (Direction)side, (ModelState)modelState);
                    if (definition.hasEmissivity()) {
                        QuadTransformers.settingEmissivity((int)definition.emissivity()).processInPlace(quad);
                    }
                    layerBuilder.addQuad(quad);
                }
            }
            RenderTypeGroup layerRenderTypes = definition.renderTypeName() != null ? this.getRenderTypes(context, definition.renderTypeName()) : modelRenderTypes;
            layerBuilder.setRenderTypes(layerRenderTypes);
        }
        return new ItemLayerBakedModel(context.useAmbientOcclusion(), context.isGui3d(), context.useBlockLight(), particleIcon, context.getTransforms(), ItemOverrides.EMPTY, this.useCustomRenderer, (List<BakedItemLayer.Builder>)layerBuilders);
    }

    private static class Loader
    extends ElementGroupGeometry.GeometryLoader {
        private Loader() {
        }

        @Override
        protected ElementGroupGeometry createGeometry(JsonObject rootJson, List<BlockElement> elements, Map<String, IntList> elementGroups) throws JsonParseException {
            JsonArray layersArray = GsonHelper.getAsJsonArray((JsonObject)rootJson, (String)"layers");
            ObjectArrayList layerDefinitions = new ObjectArrayList();
            for (JsonElement je : layersArray) {
                JsonObject layerJson = je.getAsJsonObject();
                String name = GsonHelper.getAsString((JsonObject)layerJson, (String)"name");
                List<String> groups = LimaJsonUtil.stringsArrayStream(GsonHelper.getAsJsonArray((JsonObject)layerJson, (String)"groups")).filter(elementGroups::containsKey).toList();
                int emissivity = GsonHelper.getAsInt((JsonObject)layerJson, (String)"emissivity", (int)0);
                ResourceLocation rtn = layerJson.has("render_type") ? LimaJsonUtil.getAsResourceLocation(layerJson, "render_type") : null;
                layerDefinitions.add(new GeometryLayerDefinition(name, groups, emissivity, rtn));
            }
            boolean useCustomRenderer = GsonHelper.getAsBoolean((JsonObject)rootJson, (String)"custom_renderer", (boolean)false);
            return new ItemLayerGeometry(elements, elementGroups, (List<GeometryLayerDefinition>)layerDefinitions, useCustomRenderer);
        }

        @Override
        public ResourceLocation getLoaderId() {
            return LOADER_ID;
        }
    }
}

