/*
 * Decompiled with CFR 0.152.
 */
package liedge.limacore.client.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public abstract class CustomRenderTypeParticle
extends Particle {
    protected CustomRenderTypeParticle(ClientLevel level, double x, double y, double z) {
        super(level, x, y, z);
    }

    protected abstract void renderParticle(VertexConsumer var1, Matrix4f var2, Camera var3, float var4);

    protected abstract RenderType getCustomRenderType();

    public void render(VertexConsumer ignored, Camera camera, float partialTicks) {
        Vec3 camPos = camera.getPosition();
        float px = (float)(Mth.lerp((double)partialTicks, (double)this.xo, (double)this.x) - camPos.x);
        float py = (float)(Mth.lerp((double)partialTicks, (double)this.yo, (double)this.y) - camPos.y);
        float pz = (float)(Mth.lerp((double)partialTicks, (double)this.zo, (double)this.z) - camPos.z);
        Matrix4f mx4 = new Matrix4f();
        mx4.translate(px, py, pz);
        MultiBufferSource.BufferSource bufferSource = Minecraft.getInstance().renderBuffers().bufferSource();
        VertexConsumer buffer = bufferSource.getBuffer(this.getCustomRenderType());
        this.renderParticle(buffer, mx4, camera, partialTicks);
        bufferSource.endBatch();
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.CUSTOM;
    }
}

