/*
 * Decompiled with CFR 0.152.
 */
package liedge.limacore.data;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;

public final class EmptyFieldMapCodec<A>
extends MapCodec<A> {
    private final String fieldKey;
    private final A unitValue;

    public static <T> MapCodec<List<T>> emptyListField(String fieldKey) {
        return new EmptyFieldMapCodec<List<T>>(fieldKey, List.of());
    }

    public EmptyFieldMapCodec(String fieldKey, A unitValue) {
        this.fieldKey = fieldKey;
        this.unitValue = unitValue;
    }

    public <T> Stream<T> keys(DynamicOps<T> ops) {
        return Stream.empty();
    }

    public <T> DataResult<A> decode(DynamicOps<T> ops, MapLike<T> input) {
        if (input.get(this.fieldKey) != null) {
            return DataResult.error(() -> String.format("Field '%s' must be absent during decoding.", this.fieldKey));
        }
        return DataResult.success(this.unitValue);
    }

    public <T> RecordBuilder<T> encode(A input, DynamicOps<T> ops, RecordBuilder<T> prefix) {
        if (!Objects.equals(this.unitValue, input)) {
            return prefix.withErrorsFrom(DataResult.error(() -> String.format("Cannot encode field '%s': it does not match the default unit value.", this.fieldKey)));
        }
        return prefix;
    }

    public String toString() {
        return "EmptyFieldMapCodec[key=" + this.fieldKey + "]";
    }
}

