/*
 * Decompiled with CFR 0.152.
 */
package liedge.limacore.data;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Function3;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapDecoder;
import com.mojang.serialization.MapEncoder;
import com.mojang.serialization.codecs.PrimitiveCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectSets;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import liedge.limacore.data.EmptyFieldMapCodec;
import liedge.limacore.data.LimaEnumCodec;
import liedge.limacore.lib.math.LimaCoreMath;
import liedge.limacore.util.LimaCoreUtil;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import net.neoforged.neoforge.common.util.NeoForgeExtraCodecs;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;
import org.jetbrains.annotations.Nullable;
import org.joml.AxisAngle4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.slf4j.Logger;

public final class LimaCoreCodecs {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final String INGREDIENTS_KEY = "ingredients";
    public static final String FLUID_INGREDIENTS_KEY = "fluid_ingredients";
    public static final String FLUID_RESULTS_KEY = "fluid_results";
    public static final Codec<Float> DEG_TO_RAD_FLOAT = new PrimitiveCodec<Float>(){

        public <T> DataResult<Float> read(DynamicOps<T> ops, T input) {
            return ops.getNumberValue(input).map(n -> Float.valueOf(LimaCoreMath.toRad(n.floatValue())));
        }

        public <T> T write(DynamicOps<T> ops, Float value) {
            return (T)ops.createFloat(LimaCoreMath.toDeg(value.floatValue()));
        }

        public String toString() {
            return "Degrees to Radians Float";
        }
    };
    public static final Codec<Integer> HEXADECIMAL_INT = new PrimitiveCodec<Integer>(){

        public <T> DataResult<Integer> read(DynamicOps<T> ops, T input) {
            return ops.getStringValue(input).flatMap(string -> {
                try {
                    return DataResult.success((Object)LimaCoreMath.parseHexadecimal(string));
                }
                catch (NumberFormatException ex) {
                    return DataResult.error(() -> "Not a valid hexadecimal string: " + ex.getMessage());
                }
            });
        }

        public <T> T write(DynamicOps<T> ops, Integer value) {
            return (T)ops.createString("#" + Integer.toHexString(value));
        }

        public String toString() {
            return "Hexadecimal Int";
        }
    };
    public static final LimaEnumCodec<Direction> STRICT_DIRECTION = LimaEnumCodec.create(Direction.class);
    public static final Codec<Vector3f> VECTOR3F_16X = ExtraCodecs.VECTOR3F.xmap(vec -> vec.mul(0.0625f), vec -> vec.mul(16.0f));
    public static final MapCodec<ItemStack> ITEM_STACK_MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ItemStack.ITEM_NON_AIR_CODEC.fieldOf("id").forGetter(ItemStack::getItemHolder), (App)Codec.intRange((int)1, (int)99).fieldOf("count").orElse((Object)1).forGetter(ItemStack::getCount), (App)DataComponentPatch.CODEC.optionalFieldOf("components", (Object)DataComponentPatch.EMPTY).forGetter(ItemStack::getComponentsPatch)).apply((Applicative)instance, ItemStack::new));
    public static final MapCodec<FluidStack> FLUID_STACK_MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)FluidStack.FLUID_NON_EMPTY_CODEC.fieldOf("id").forGetter(FluidStack::getFluidHolder), (App)ExtraCodecs.POSITIVE_INT.fieldOf("amount").forGetter(FluidStack::getAmount), (App)DataComponentPatch.CODEC.optionalFieldOf("components", (Object)DataComponentPatch.EMPTY).forGetter(FluidStack::getComponentsPatch)).apply((Applicative)instance, FluidStack::new));
    public static Codec<Vector3f> AXIS_VECTOR = Codec.withAlternative((Codec)ExtraCodecs.VECTOR3F, (Codec)Direction.Axis.CODEC, LimaCoreMath::unitVecForAxis);
    public static final MapCodec<AxisAngle4f> UNIT_AXIS_ANGLE4F = RecordCodecBuilder.mapCodec(instance -> instance.group((App)DEG_TO_RAD_FLOAT.fieldOf("angle").forGetter(o -> Float.valueOf(o.angle)), (App)AXIS_VECTOR.fieldOf("axis").forGetter(o -> new Vector3f(o.x, o.y, o.z))).apply((Applicative)instance, AxisAngle4f::new));
    public static final MapCodec<Quaternionf> UNIT_QUATERNION = UNIT_AXIS_ANGLE4F.xmap(Quaternionf::new, AxisAngle4f::new);
    public static final MapCodec<List<SizedIngredient>> ITEM_INGREDIENTS_UNIT = EmptyFieldMapCodec.emptyListField("ingredients");
    public static final MapCodec<List<SizedFluidIngredient>> FLUID_INGREDIENTS_UNIT = EmptyFieldMapCodec.emptyListField("fluid_ingredients");
    public static final MapCodec<List<FluidStack>> FLUID_RESULTS_UNIT = EmptyFieldMapCodec.emptyListField("fluid_results");

    private LimaCoreCodecs() {
    }

    public static <N extends Number> Codec<N> openStartNumberRange(Codec<N> baseCodec, N minExclusive, N maxInclusive) {
        return baseCodec.validate(num -> {
            if (((Comparable)((Object)num)).compareTo(minExclusive) > 0 && ((Comparable)((Object)num)).compareTo(maxInclusive) <= 0) {
                return DataResult.success((Object)num);
            }
            return DataResult.error(() -> String.format("Value %s outside of valid range (%s,%s]", num, minExclusive, maxInclusive));
        });
    }

    public static <N extends Number> Codec<N> openEndNumberRange(Codec<N> baseCodec, N minInclusive, N maxExclusive) {
        return baseCodec.validate(num -> {
            if (((Comparable)((Object)num)).compareTo(minInclusive) >= 0 && ((Comparable)((Object)num)).compareTo(maxExclusive) < 0) {
                return DataResult.success((Object)num);
            }
            return DataResult.error(() -> String.format("Value %s outside of valid range [%s,%s)", num, minInclusive, maxExclusive));
        });
    }

    public static Codec<Float> floatOpenStartRange(float minExclusive, float maxInclusive) {
        return LimaCoreCodecs.openStartNumberRange(Codec.FLOAT, Float.valueOf(minExclusive), Float.valueOf(maxInclusive));
    }

    public static Codec<Float> floatOpenEndRange(float minInclusive, float maxExclusive) {
        return LimaCoreCodecs.openEndNumberRange(Codec.FLOAT, Float.valueOf(minInclusive), Float.valueOf(maxExclusive));
    }

    public static <E> MapCodec<List<E>> singleOrPluralNonEmpty(Codec<E> elementCodec, String singularFieldName) {
        MapCodec singular = elementCodec.fieldOf(singularFieldName);
        MapCodec plural = ExtraCodecs.nonEmptyList((Codec)elementCodec.listOf()).fieldOf(singularFieldName + "s");
        return Codec.mapEither((MapCodec)singular, (MapCodec)plural).xmap(either -> (List)either.map(List::of, Function.identity()), list -> list.size() == 1 ? Either.left(list.getFirst()) : Either.right((Object)list));
    }

    public static <E extends Enum<E>> Codec<Set<E>> enumSetCodec(Codec<E> enumElementCodec) {
        return enumElementCodec.listOf().xmap(list -> list.isEmpty() ? Set.of() : ImmutableSet.copyOf(EnumSet.copyOf(list)), List::copyOf);
    }

    public static <E> Codec<ObjectSet<E>> objectSetCodec(Codec<E> elementCodec) {
        return elementCodec.listOf().xmap(list -> ObjectSets.unmodifiable((ObjectSet)new ObjectLinkedOpenHashSet((Collection)list)), List::copyOf);
    }

    public static <K> Codec<Object2IntMap<K>> object2IntMap(Codec<K> keyCodec, Codec<Integer> valueCodec) {
        return Codec.unboundedMap(keyCodec, valueCodec).xmap(map -> Object2IntMaps.unmodifiable((Object2IntMap)new Object2IntOpenHashMap(map)), Function.identity());
    }

    public static <K> Codec<Object2IntMap<K>> object2IntMap(Codec<K> keyCodec) {
        return LimaCoreCodecs.object2IntMap(keyCodec, (Codec<Integer>)Codec.INT);
    }

    public static <R, T extends R> Codec<T> classCastRegistryCodec(Registry<R> registry, Class<T> valueClass) {
        return registry.byNameCodec().comapFlatMap(o -> LimaCoreCodecs.nullableDataResult(LimaCoreUtil.castOrNull(valueClass, o), () -> "Registry object is not an instance of '" + valueClass.getSimpleName()), Function.identity());
    }

    public static <A, L extends A, R extends A> DataResult<Either<L, R>> xorSubclassDataResult(A value, Class<L> leftClass, Class<R> rightClass) {
        if (leftClass.isInstance(value)) {
            return DataResult.success((Object)Either.left(leftClass.cast(value)));
        }
        if (rightClass.isInstance(value)) {
            return DataResult.success((Object)Either.right(rightClass.cast(value)));
        }
        return DataResult.error(() -> "Value is not an instance of either " + leftClass.getName() + " or " + rightClass.getName());
    }

    public static <A, L extends A, R extends A> Codec<A> xorSubclassCodec(Codec<L> leftCodec, Codec<R> rightCodec, Class<L> leftClass, Class<R> rightClass) {
        return Codec.xor(leftCodec, rightCodec).flatComapMap(Either::unwrap, value -> LimaCoreCodecs.xorSubclassDataResult(value, leftClass, rightClass));
    }

    public static <A, L extends A, R extends A> MapCodec<A> xorSubclassMapCodec(MapCodec<L> leftCodec, MapCodec<R> rightCodec, Class<L> leftClass, Class<R> rightClass) {
        return LimaCoreCodecs.flatComapMapMapCodec(NeoForgeExtraCodecs.xor(leftCodec, rightCodec), value -> LimaCoreCodecs.xorSubclassDataResult(value, leftClass, rightClass), Either::unwrap);
    }

    private static <A, F extends A> Either<F, A> inlinedSubclassEither(Class<F> inlineClass, A value) {
        return inlineClass.isInstance(value) ? Either.left(inlineClass.cast(value)) : Either.right(value);
    }

    public static <T, A, F extends A> Codec<A> dispatchWithInline(Codec<T> typeCodec, String typeKey, Class<F> inlineClass, Codec<F> inlineCodec, Function<? super A, ? extends T> typeGetter, Function<? super T, MapCodec<? extends A>> codecGetter) {
        return Codec.xor(inlineCodec, (Codec)typeCodec.dispatch(typeKey, typeGetter, codecGetter)).xmap(Either::unwrap, value -> LimaCoreCodecs.inlinedSubclassEither(inlineClass, value));
    }

    public static <T, A, F extends A> Codec<A> dispatchWithInline(Codec<T> typeCodec, Class<F> inlineClass, Codec<F> inlineCodec, Function<? super A, ? extends T> typeGetter, Function<? super T, MapCodec<? extends A>> codecGetter) {
        return LimaCoreCodecs.dispatchWithInline(typeCodec, "type", inlineClass, inlineCodec, typeGetter, codecGetter);
    }

    public static <T, A, F extends A> MapCodec<A> dispatchMapWithInline(Codec<T> typeCodec, String typeKey, Class<F> inlineClass, MapCodec<F> inlineCodec, Function<? super A, ? extends T> typeGetter, Function<? super T, MapCodec<? extends A>> codecGetter) {
        return NeoForgeExtraCodecs.xor(inlineCodec, (MapCodec)typeCodec.dispatchMap(typeKey, typeGetter, codecGetter)).xmap(Either::unwrap, value -> inlineClass.isInstance(value) ? Either.left(inlineClass.cast(value)) : Either.right((Object)value));
    }

    public static <T, A, F extends A> MapCodec<A> dispatchMapWithInline(Codec<T> typeCodec, Class<F> inlineClass, MapCodec<F> inlineCodec, Function<? super A, ? extends T> typeGetter, Function<? super T, MapCodec<? extends A>> codecGetter) {
        return LimaCoreCodecs.dispatchMapWithInline(typeCodec, "type", inlineClass, inlineCodec, typeGetter, codecGetter);
    }

    public static <E> MapCodec<List<E>> smartSizedListField(Codec<E> elementCodec, String fieldName, int minInclusive, int maxInclusive) {
        Preconditions.checkArgument((minInclusive >= 0 ? 1 : 0) != 0, (Object)"Minimum size must be non-negative.");
        Preconditions.checkArgument((maxInclusive >= minInclusive ? 1 : 0) != 0, (Object)"Maximum size must be greater than or equal to minimum size.");
        Codec listCodec = elementCodec.listOf(minInclusive, maxInclusive);
        return minInclusive == 0 ? listCodec.optionalFieldOf(fieldName, List.of()) : listCodec.fieldOf(fieldName);
    }

    public static MapCodec<List<SizedIngredient>> sizedIngredients(int minInclusive, int maxInclusive) {
        return LimaCoreCodecs.smartSizedListField(SizedIngredient.FLAT_CODEC, INGREDIENTS_KEY, minInclusive, maxInclusive);
    }

    public static MapCodec<List<SizedFluidIngredient>> sizedFluidIngredients(int minInclusive, int maxInclusive) {
        return LimaCoreCodecs.smartSizedListField(SizedFluidIngredient.FLAT_CODEC, FLUID_INGREDIENTS_KEY, minInclusive, maxInclusive);
    }

    public static MapCodec<List<FluidStack>> fluidResults(int minInclusive, int maxInclusive) {
        return LimaCoreCodecs.smartSizedListField(FluidStack.CODEC, FLUID_RESULTS_KEY, minInclusive, maxInclusive);
    }

    public static <E, A> DataResult<A> fixedListFlatMap(List<E> list, int expectedSize, Function<IntFunction<E>, ? extends A> elementAccessor) {
        if (list.size() == expectedSize) {
            try {
                A result = elementAccessor.apply(list::get);
                return DataResult.success(result);
            }
            catch (IndexOutOfBoundsException ignored) {
                return DataResult.error(() -> "Input mapping function accesses index outside valid range [0," + expectedSize + ")");
            }
        }
        return DataResult.error(() -> "Input is not a list of " + expectedSize + " elements.");
    }

    public static <T> DataResult<T> nullableDataResult(@Nullable T value, Supplier<String> errorMessageSupplier) {
        return value != null ? DataResult.success(value) : DataResult.error(errorMessageSupplier);
    }

    public static <E, A> Codec<A> fixedListComapFlatMap(Codec<E> elementCodec, int size, Function<IntFunction<E>, ? extends A> to, Function<? super A, ? extends List<E>> from) {
        return elementCodec.listOf().comapFlatMap(rawList -> LimaCoreCodecs.fixedListFlatMap(rawList, size, to), from);
    }

    public static <E, T> Codec<T> triComapFlatMap(Codec<E> elementCodec, Function3<E, E, E, ? extends T> to, Function<? super T, ? extends List<E>> from) {
        return LimaCoreCodecs.fixedListComapFlatMap(elementCodec, 3, list -> to.apply(list.apply(0), list.apply(1), list.apply(2)), from);
    }

    public static <A, S> MapCodec<S> comapFlatMapMapCodec(MapCodec<A> baseCodec, Function<? super S, ? extends A> to, Function<? super A, ? extends DataResult<? extends S>> from) {
        return MapCodec.of((MapEncoder)baseCodec.comap(to), (MapDecoder)baseCodec.flatMap(from));
    }

    public static <A, S> MapCodec<S> flatComapMapMapCodec(MapCodec<A> baseCodec, Function<? super S, ? extends DataResult<? extends A>> to, Function<? super A, ? extends S> from) {
        return MapCodec.of((MapEncoder)baseCodec.flatComap(to), (MapDecoder)baseCodec.map(from));
    }

    public static <A, U> U strictEncode(Codec<A> codec, DynamicOps<U> ops, A input) {
        return (U)codec.encodeStart(ops, input).getOrThrow(msg -> {
            LOGGER.error("Codec {} failed strict encoding: {}", (Object)codec, msg);
            throw new IllegalStateException("Encoding error.");
        });
    }

    @Nullable
    public static <A, U> U tryEncode(Codec<A> codec, DynamicOps<U> ops, A input) {
        return LimaCoreCodecs.partialEncode(codec, ops, input).orElse(null);
    }

    public static <A, U> void tryEncodeTo(Codec<A> codec, DynamicOps<U> ops, A input, Consumer<? super U> consumer) {
        LimaCoreCodecs.partialEncode(codec, ops, input).ifPresent(consumer);
    }

    public static <A, U> A strictDecode(Codec<A> codec, DynamicOps<U> ops, U input) {
        return (A)((Pair)codec.decode(ops, input).getOrThrow(msg -> {
            LOGGER.error("Codec {} failed strict decoding: {}", (Object)codec, msg);
            throw new IllegalStateException("Decoding error.");
        })).getFirst();
    }

    @Nullable
    public static <A, U> A tryDecode(Codec<A> codec, DynamicOps<U> ops, U input) {
        return LimaCoreCodecs.partialDecode(codec, ops, input).orElse(null);
    }

    public static <A, U> A tryDecode(Codec<A> codec, DynamicOps<U> ops, U input, A fallback) {
        return LimaCoreCodecs.partialDecode(codec, ops, input).orElse(fallback);
    }

    private static <A, U> Optional<U> partialEncode(Codec<A> codec, DynamicOps<U> ops, A input) {
        return codec.encodeStart(ops, input).resultOrPartial(msg -> LOGGER.warn("Codec {} encountered errors during encoding: {}", (Object)codec, msg));
    }

    private static <A, U> Optional<A> partialDecode(Codec<A> codec, DynamicOps<U> ops, U input) {
        return codec.parse(ops, input).resultOrPartial(msg -> LOGGER.warn("Codec {} encountered errors during decoding: {}", (Object)codec, msg));
    }
}

