/*
 * Decompiled with CFR 0.152.
 */
package liedge.limacore.data;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import liedge.limacore.data.LimaCoreCodecs;
import liedge.limacore.util.LimaCollectionsUtil;
import liedge.limacore.util.LimaStreamsUtil;
import net.minecraft.util.StringRepresentable;
import org.jetbrains.annotations.Nullable;

public final class LimaEnumCodec<A extends Enum<A>>
implements Codec<A> {
    private final Class<A> enumClass;
    private final Map<String, A> nameLookup;
    private final String validValueString;
    private final Codec<A> baseCodec;

    public static <E extends Enum<E>> LimaEnumCodec<E> create(Class<E> enumClass, List<E> validValues) {
        return new LimaEnumCodec<E>(enumClass, validValues);
    }

    public static <E extends Enum<E>> LimaEnumCodec<E> create(Class<E> enumClass) {
        return new LimaEnumCodec<Enum>(enumClass, List.of(LimaCollectionsUtil.checkedEnumConstants(enumClass)));
    }

    private LimaEnumCodec(Class<A> enumClass, Collection<A> values) {
        this.enumClass = enumClass;
        this.nameLookup = (Map)values.stream().collect(LimaStreamsUtil.toUnmodifiableObject2ObjectMap(rec$ -> ((StringRepresentable)rec$).getSerializedName(), Function.identity()));
        this.validValueString = values.stream().map(rec$ -> ((StringRepresentable)rec$).getSerializedName()).collect(Collectors.joining(","));
        this.baseCodec = Codec.STRING.flatXmap(sn -> this.nameLookup.containsKey(sn) ? DataResult.success((Object)((Enum)this.nameLookup.get(sn))) : DataResult.error(() -> "Unknown or disallowed element name '" + sn + "', allowed names: " + this.validValueString), a -> this.nameLookup.containsKey(((StringRepresentable)a).getSerializedName()) ? DataResult.success((Object)((StringRepresentable)a).getSerializedName()) : DataResult.error(() -> "Element not allowed for serialization, allowed elements: " + this.validValueString));
    }

    @Nullable
    public A byName(String name) {
        return (A)((Enum)this.nameLookup.get(name));
    }

    public A byNameOrThrow(String name) {
        return (A)((Enum)Objects.requireNonNull(this.byName(name), "Unknown element name '" + name + "' in " + name));
    }

    public A byNameOrElse(String name, A fallback) {
        return (A)((Enum)Objects.requireNonNullElse(this.byName(name), fallback));
    }

    public Codec<Set<A>> setOf() {
        return LimaCoreCodecs.enumSetCodec(this);
    }

    public LimaEnumCodec<A> restricted(List<A> validValues) {
        return new LimaEnumCodec<A>(this.enumClass, validValues);
    }

    public <B, F extends B> Codec<B> dispatchWithInline(String typeKey, Class<F> inlineClass, Codec<F> inlineCodec, Function<? super B, ? extends A> typeGetter, Function<? super A, MapCodec<? extends B>> codecGetter) {
        return LimaCoreCodecs.dispatchWithInline(this, typeKey, inlineClass, inlineCodec, typeGetter, codecGetter);
    }

    public <B, F extends B> Codec<B> dispatchWithInline(Class<F> inlineClass, Codec<F> inlineCodec, Function<? super B, ? extends A> typeGetter, Function<? super A, MapCodec<? extends B>> codecGetter) {
        return LimaCoreCodecs.dispatchWithInline(this, inlineClass, inlineCodec, typeGetter, codecGetter);
    }

    public <B, F extends B> MapCodec<B> dispatchMapWithInline(String typeKey, Class<F> inlineClass, MapCodec<F> inlineCodec, Function<? super B, ? extends A> typeGetter, Function<? super A, MapCodec<? extends B>> codecGetter) {
        return LimaCoreCodecs.dispatchMapWithInline(this, typeKey, inlineClass, inlineCodec, typeGetter, codecGetter);
    }

    public <B, F extends B> MapCodec<B> dispatchMapWithInline(Class<F> inlineClass, MapCodec<F> inlineCodec, Function<? super B, ? extends A> typeGetter, Function<? super A, MapCodec<? extends B>> codecGetter) {
        return LimaCoreCodecs.dispatchMapWithInline(this, inlineClass, inlineCodec, typeGetter, codecGetter);
    }

    public <T> DataResult<Pair<A, T>> decode(DynamicOps<T> ops, T input) {
        return this.baseCodec.decode(ops, input);
    }

    public <T> DataResult<T> encode(A input, DynamicOps<T> ops, T prefix) {
        return this.baseCodec.encode(input, ops, prefix);
    }

    public String toString() {
        return "LimaEnumCodec[" + this.enumClass.getSimpleName() + "]";
    }
}

