/*
 * Decompiled with CFR 0.152.
 */
package liedge.limacore.data.generation;

import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import liedge.limacore.data.LimaCoreCodecs;
import liedge.limacore.lib.ModResources;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.neoforged.neoforge.common.conditions.ConditionalOps;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.WithConditions;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.common.data.JsonCodecProvider;

public abstract class LimaJsonCodecProvider<T>
extends JsonCodecProvider<T> {
    protected final ModResources resources;

    protected LimaJsonCodecProvider(PackOutput packOutput, PackOutput.Target target, String directory, PackType packType, Codec<T> codec, CompletableFuture<HolderLookup.Provider> registries, ModResources resources, ExistingFileHelper helper) {
        super(packOutput, target, directory, packType, codec, registries, resources.modid(), helper);
        this.resources = resources;
    }

    protected abstract void gather(HolderLookup.Provider var1);

    @Deprecated
    protected final void gather() {
    }

    public final CompletableFuture<?> run(CachedOutput cache) {
        return this.lookupProvider.thenCompose(registries -> this.runAsync(cache, (HolderLookup.Provider)registries));
    }

    private CompletableFuture<?> runAsync(CachedOutput cache, HolderLookup.Provider registries) {
        ObjectArrayList futures = new ObjectArrayList();
        ConditionalOps ops = new ConditionalOps(registries.createSerializationContext((DynamicOps)JsonOps.INSTANCE), ICondition.IContext.EMPTY);
        Codec wrappedCodec = ConditionalOps.createConditionalCodecWithConditions((Codec)this.codec);
        this.gather(registries);
        for (Map.Entry entry : this.conditions.entrySet()) {
            Path path = this.pathProvider.json((ResourceLocation)entry.getKey());
            CompletionStage future = CompletableFuture.supplyAsync(() -> LimaJsonCodecProvider.lambda$runAsync$1(wrappedCodec, (DynamicOps)ops, entry)).thenComposeAsync(json -> DataProvider.saveStable((CachedOutput)cache, (JsonElement)json, (Path)path));
            futures.add(future);
        }
        return CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
    }

    protected void unconditional(String name, T value) {
        this.unconditional(this.resources.location(name), value);
    }

    protected void conditionally(String name, Consumer<WithConditions.Builder<T>> configurator) {
        this.conditionally(this.resources.location(name), configurator);
    }

    private static /* synthetic */ JsonElement lambda$runAsync$1(Codec wrappedCodec, DynamicOps ops, Map.Entry entry) {
        return (JsonElement)LimaCoreCodecs.strictEncode(wrappedCodec, ops, Optional.of((WithConditions)entry.getValue()));
    }
}

