/*
 * Decompiled with CFR 0.152.
 */
package liedge.limacore.data.generation;

import java.util.Arrays;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import liedge.limacore.advancement.LimaAdvancementUtil;
import liedge.limacore.data.generation.LimaSoundDefinitionsProvider;
import liedge.limacore.lib.ModResources;
import liedge.limacore.lib.Translatable;
import liedge.limacore.menu.LimaMenuType;
import liedge.limacore.util.LimaRegistryUtil;
import net.minecraft.core.Holder;
import net.minecraft.data.PackOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.neoforged.neoforge.common.data.LanguageProvider;
import net.neoforged.neoforge.fluids.FluidType;
import org.apache.commons.lang3.StringUtils;

public abstract class LimaLanguageProvider
extends LanguageProvider {
    protected final ModResources modResources;

    public LimaLanguageProvider(PackOutput output, ModResources modResources, String locale) {
        super(output, modResources.modid(), locale);
        this.modResources = modResources;
    }

    public LimaLanguageProvider(PackOutput output, ModResources modResources) {
        this(output, modResources, "en_us");
    }

    public static String localizeSimpleName(String path) {
        return Arrays.stream(path.split("_")).map(StringUtils::capitalize).collect(Collectors.joining(" "));
    }

    public static String localizeSimpleName(StringRepresentable representable) {
        return LimaLanguageProvider.localizeSimpleName(representable.getSerializedName());
    }

    protected void soundEvent(Holder<SoundEvent> soundEvent, String translation) {
        this.add(LimaSoundDefinitionsProvider.defaultSubtitleKey(soundEvent), translation);
    }

    protected void advancement(ResourceLocation id, String titleTranslation, String descriptionTranslation) {
        this.add(LimaAdvancementUtil.defaultAdvancementTitleKey(id), titleTranslation);
        this.add(LimaAdvancementUtil.defaultAdvancementDescriptionKey(id), descriptionTranslation);
    }

    protected void enchantment(ResourceKey<Enchantment> enchantmentKey, String translation) {
        this.add("enchantment", enchantmentKey.location().getPath(), translation);
    }

    protected void creativeTab(Supplier<? extends CreativeModeTab> tabSupplier, String value) {
        Component tabTitle = tabSupplier.get().getDisplayName();
        ComponentContents componentContents = tabTitle.getContents();
        if (!(componentContents instanceof TranslatableContents)) {
            throw new IllegalArgumentException("Creative mode tab display name is not translatable");
        }
        TranslatableContents translatable = (TranslatableContents)componentContents;
        this.add(translatable.getKey(), value);
    }

    protected void fluidType(Supplier<? extends FluidType> supplier, String fluidValue) {
        this.add(supplier.get().getDescriptionId(), fluidValue);
    }

    protected void menuTitle(Supplier<? extends LimaMenuType<?, ?>> supplier, String value) {
        this.add(Objects.requireNonNull(supplier.get().getDefaultTitle(), "Menu does not have a default title"), value);
    }

    protected void potion(Supplier<? extends PotionItem> item, String potionValue) {
        String name = LimaRegistryUtil.getItemName((Item)item.get());
        this.add("item.minecraft.potion.effect." + name, "Potion of " + potionValue);
        this.add("item.minecraft.splash_potion.effect." + name, "Splash Potion of " + potionValue);
        this.add("item.minecraft.lingering_potion.effect." + name, "Lingering Potion of " + potionValue);
    }

    protected void damageTypeVariants(ResourceKey<DamageType> damageTypeKey, Consumer<BiConsumer<String, String>> collector) {
        String baseKey = ModResources.prefixedIdLangKey("death.attack", damageTypeKey.location());
        collector.accept((variant, value) -> {
            String key = StringUtils.isNotBlank((CharSequence)variant) ? baseKey + "." + variant : baseKey;
            this.add(key, (String)value);
        });
    }

    protected void damageTypeAndVariants(ResourceKey<DamageType> damageTypeKey, String defaultValue, Consumer<BiConsumer<String, String>> collector) {
        this.damageTypeVariants(damageTypeKey, c -> {
            c.accept("", defaultValue);
            collector.accept((BiConsumer<String, String>)c);
        });
    }

    protected void damageType(ResourceKey<DamageType> damageTypeKey, String value) {
        this.damageTypeAndVariants(damageTypeKey, value, collector -> {});
    }

    protected void entityAttackDamageType(ResourceKey<DamageType> damageTypeKey, String value, String itemValue) {
        this.damageTypeAndVariants(damageTypeKey, value, collector -> collector.accept("item", itemValue));
    }

    protected void ambientDamageType(ResourceKey<DamageType> damageTypeKey, String value, String playerValue) {
        this.damageTypeAndVariants(damageTypeKey, value, collector -> collector.accept("player", playerValue));
    }

    protected void add(Supplier<? extends Translatable> translatableSupplier, String value) {
        this.add(translatableSupplier.get(), value);
    }

    protected void add(Translatable translatable, String value) {
        this.add(translatable.descriptionId(), value);
    }

    protected void add(String prefix, String suffix, String value) {
        String key = prefix + "." + this.modResources.modid() + "." + suffix;
        this.add(key, value);
    }
}

