/*
 * Decompiled with CFR 0.152.
 */
package liedge.limacore.data.generation;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.stream.Stream;
import liedge.limacore.util.LimaRegistryUtil;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagBuilder;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.Nullable;

public abstract class LimaTagsProvider<T>
extends TagsProvider<T> {
    private final Map<TagKey<T>, LimaTagHelper<T>> helpers = new Object2ObjectOpenHashMap();

    protected LimaTagsProvider(PackOutput packOutput, ResourceKey<? extends Registry<T>> registryKey, String modid, CompletableFuture<HolderLookup.Provider> lookupProvider, @Nullable ExistingFileHelper helper) {
        super(packOutput, registryKey, lookupProvider, modid, helper);
    }

    @Nullable
    protected Registry<T> getTagRegistry() {
        return null;
    }

    protected ResourceKey<T> resolveKey(T value) {
        Registry<T> registry = Objects.requireNonNull(this.getTagRegistry(), "Tag provider does not support resolving keys from values.");
        return LimaRegistryUtil.getNonNullResourceKey(value, registry);
    }

    protected LimaTagHelper<T> buildTag(TagKey<T> tag) {
        return this.helpers.computeIfAbsent(tag, key -> new LimaTagHelper(this, key));
    }

    @SafeVarargs
    protected final void reverseElementToTags(ResourceKey<T> resourceKey, TagKey<T> ... tags) {
        Stream.of(tags).forEach(tag -> this.getOrCreateRawBuilder((TagKey)tag).addElement(resourceKey.location()));
    }

    @SafeVarargs
    protected final void reverseElementToTags(T value, TagKey<T> ... tags) {
        this.reverseElementToTags((T)this.resolveKey(value), tags);
    }

    @SafeVarargs
    protected final void reverseElementToTags(Holder<T> holder, TagKey<T> ... tags) {
        this.reverseElementToTags(holder.value(), tags);
    }

    @SafeVarargs
    protected final void reverseTagToTags(TagKey<T> identity, TagKey<T> ... destinationTags) {
        Stream.of(destinationTags).forEach(tag -> this.getOrCreateRawBuilder((TagKey)tag).addTag(identity.location()));
    }

    public static class LimaTagHelper<T> {
        private final LimaTagsProvider<T> parent;
        private final TagBuilder rawBuilder;
        private final List<ResourceLocation> elements = new ObjectArrayList();

        public LimaTagHelper(LimaTagsProvider<T> parent, TagKey<T> tag) {
            this.parent = parent;
            this.rawBuilder = ((LimaTagsProvider)parent).getOrCreateRawBuilder(tag);
        }

        private LimaTagHelper<T> addInternal(ResourceLocation location) {
            this.rawBuilder.addElement(location);
            this.elements.add(location);
            return this;
        }

        public LimaTagHelper<T> internalBuilder(Consumer<TagBuilder> consumer) {
            consumer.accept(this.rawBuilder);
            return this;
        }

        public LimaTagHelper<T> add(ResourceKey<T> key) {
            return this.addInternal(key.location());
        }

        public LimaTagHelper<T> add(T value) {
            ResourceKey<T> key = this.parent.resolveKey(value);
            return this.add((T)key);
        }

        public LimaTagHelper<T> add(Holder<T> holder) {
            return this.add((T)holder.value());
        }

        @SafeVarargs
        public final LimaTagHelper<T> add(ResourceKey<T> ... keys) {
            Stream.of(keys).map(ResourceKey::location).forEach(this::addInternal);
            return this;
        }

        @SafeVarargs
        public final LimaTagHelper<T> add(T ... values) {
            Stream.of(values).forEach(this::add);
            return this;
        }

        @SafeVarargs
        public final LimaTagHelper<T> add(Holder<T> ... holders) {
            Stream.of(holders).forEach(this::add);
            return this;
        }

        public LimaTagHelper<T> addValues(Collection<? extends T> values) {
            values.forEach(this::add);
            return this;
        }

        public LimaTagHelper<T> addHolders(Collection<Holder<T>> holders) {
            holders.forEach(this::add);
            return this;
        }

        public LimaTagHelper<T> addTag(TagKey<T> tag) {
            this.rawBuilder.addTag(tag.location());
            return this;
        }

        @SafeVarargs
        public final LimaTagHelper<T> addTags(TagKey<T> ... tags) {
            Stream.of(tags).map(TagKey::location).forEach(arg_0 -> ((TagBuilder)this.rawBuilder).addTag(arg_0));
            return this;
        }

        public LimaTagHelper<T> addOptionalTag(TagKey<T> tag) {
            this.rawBuilder.addOptionalTag(tag.location());
            return this;
        }

        @SafeVarargs
        public final LimaTagHelper<T> addOptionalTags(TagKey<T> ... tags) {
            Stream.of(tags).map(TagKey::location).forEach(arg_0 -> ((TagBuilder)this.rawBuilder).addOptionalTag(arg_0));
            return this;
        }

        public LimaTagHelper<T> addOptional(ResourceLocation element) {
            this.rawBuilder.addOptionalElement(element);
            return this;
        }

        public LimaTagHelper<T> addOptional(ResourceLocation ... elements) {
            Stream.of(elements).forEach(arg_0 -> ((TagBuilder)this.rawBuilder).addOptionalElement(arg_0));
            return this;
        }

        public void copyTo(TagKey<T> other) {
            TagBuilder otherBuilder = ((LimaTagsProvider)this.parent).getOrCreateRawBuilder(other);
            this.elements.forEach(arg_0 -> ((TagBuilder)otherBuilder).addElement(arg_0));
        }

        @SafeVarargs
        public final void copyTo(TagKey<T> ... others) {
            Stream.of(others).forEach(this::copyTo);
        }
    }

    public static abstract class ItemTags
    extends RegistryTags<Item> {
        private final CompletableFuture<TagsProvider.TagLookup<Block>> blockTagsLookup;
        private final Map<TagKey<Block>, TagKey<Item>> copyOps = new Object2ObjectOpenHashMap();

        protected ItemTags(PackOutput packOutput, String modid, CompletableFuture<TagsProvider.TagLookup<Block>> blockTagsLookup, CompletableFuture<HolderLookup.Provider> lookupProvider, @Nullable ExistingFileHelper helper) {
            super(packOutput, BuiltInRegistries.ITEM, modid, lookupProvider, helper);
            this.blockTagsLookup = blockTagsLookup;
        }

        public void copyTag(TagKey<Block> blockTag, TagKey<Item> itemTag) {
            this.copyOps.put(blockTag, itemTag);
        }

        public void copyTag(TagKey<Block> blockTag) {
            this.copyTag(blockTag, (TagKey<Item>)TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)blockTag.location()));
        }

        protected CompletableFuture<HolderLookup.Provider> createContentsProvider() {
            return super.createContentsProvider().thenCombine(this.blockTagsLookup, (provider, blockTags) -> {
                this.copyOps.forEach((blockTag, itemTag) -> {
                    TagBuilder builder = this.getOrCreateRawBuilder((TagKey)itemTag);
                    ((TagBuilder)((Optional)blockTags.apply(blockTag)).orElseThrow(() -> new IllegalStateException("Can't copy non-existent block tag " + String.valueOf(blockTag.location())))).build().forEach(arg_0 -> ((TagBuilder)builder).add(arg_0));
                });
                return provider;
            });
        }
    }

    public static abstract class RegistryTags<T>
    extends LimaTagsProvider<T> {
        private final Registry<T> registry;

        protected RegistryTags(PackOutput packOutput, Registry<T> registry, String modid, CompletableFuture<HolderLookup.Provider> lookupProvider, @Nullable ExistingFileHelper helper) {
            super(packOutput, registry.key(), modid, lookupProvider, helper);
            this.registry = registry;
        }

        @Override
        @Nullable
        protected final Registry<T> getTagRegistry() {
            return this.registry;
        }
    }
}

