/*
 * Decompiled with CFR 0.152.
 */
package liedge.limacore.data.generation;

import liedge.limacore.lib.ModResources;
import liedge.limacore.util.LimaRegistryUtil;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public interface ModelProviderExtensions {
    public ModResources modResources();

    public ExistingFileHelper fileHelper();

    default public ModelFile existingModel(ResourceLocation location) {
        return new ModelFile.ExistingModelFile(location, this.fileHelper());
    }

    default public ModelFile uncheckedBlockModel(String path) {
        return new ModelFile.UncheckedModelFile(this.blockFolderLocation(path));
    }

    default public ModelFile uncheckedItemModel(String path) {
        return new ModelFile.UncheckedModelFile(this.itemFolderLocation(path));
    }

    default public ResourceLocation blockFolderLocation(ModResources resources, String path) {
        return resources.location(this.blockFolderPath(path));
    }

    default public ResourceLocation blockFolderLocation(String path) {
        return this.blockFolderLocation(this.modResources(), path);
    }

    default public ResourceLocation blockFolderLocation(Block block) {
        ResourceLocation id = LimaRegistryUtil.getBlockId(block);
        return ResourceLocation.fromNamespaceAndPath((String)id.getNamespace(), (String)this.blockFolderPath(id.getPath()));
    }

    default public ResourceLocation blockFolderLocation(Holder<Block> holder) {
        return this.blockFolderLocation((Block)holder.value());
    }

    default public String blockFolderPath(String path) {
        return "block/" + path;
    }

    default public ResourceLocation itemFolderLocation(ModResources resources, String path) {
        return resources.location(this.itemFolderPath(path));
    }

    default public ResourceLocation itemFolderLocation(String path) {
        return this.itemFolderLocation(this.modResources(), path);
    }

    default public ResourceLocation itemFolderLocation(ItemLike item) {
        ResourceLocation id = LimaRegistryUtil.getItemId(item.asItem());
        return ResourceLocation.fromNamespaceAndPath((String)id.getNamespace(), (String)this.itemFolderPath(id.getPath()));
    }

    default public String itemFolderPath(String path) {
        return "item/" + path;
    }
}

