/*
 * Decompiled with CFR 0.152.
 */
package liedge.limacore.data.generation.recipe;

import com.google.common.base.Preconditions;
import liedge.limacore.data.generation.recipe.StandardRecipeBuilder;
import liedge.limacore.lib.ModResources;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.CookingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;

public class LimaCookingRecipeBuilder
extends StandardRecipeBuilder<AbstractCookingRecipe, LimaCookingRecipeBuilder> {
    private final int cookingTime;
    private final AbstractCookingRecipe.Factory<?> factory;
    private float experience;
    private CookingBookCategory category = CookingBookCategory.MISC;

    public LimaCookingRecipeBuilder(ModResources resources, ItemStack result, int cookingTime, AbstractCookingRecipe.Factory<?> factory) {
        super(resources, result);
        this.cookingTime = cookingTime;
        this.factory = factory;
    }

    public LimaCookingRecipeBuilder xp(float experience) {
        this.experience = experience;
        return this;
    }

    public LimaCookingRecipeBuilder bookCategory(CookingBookCategory category) {
        this.category = category;
        return this;
    }

    @Override
    protected AbstractCookingRecipe buildRecipe() {
        Preconditions.checkState((this.ingredients.size() == 1 ? 1 : 0) != 0, (Object)"Cooking recipe must have exactly 1 ingredient.");
        return this.factory.create(this.getGroupOrBlank(), this.category, (Ingredient)this.ingredients.getFirst(), this.result, this.experience, this.cookingTime);
    }
}

