/*
 * Decompiled with CFR 0.152.
 */
package liedge.limacore.data.generation.recipe;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.BiFunction;
import liedge.limacore.data.generation.recipe.LimaRecipeBuilder;
import liedge.limacore.lib.ModResources;
import liedge.limacore.recipe.ItemResult;
import liedge.limacore.recipe.LimaCustomRecipe;
import liedge.limacore.recipe.ingredient.ConsumeChanceIngredient;
import liedge.limacore.util.LimaRegistryUtil;
import net.minecraft.core.Holder;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;

public abstract class LimaCustomRecipeBuilder<R extends LimaCustomRecipe<?>, B extends LimaCustomRecipeBuilder<R, B>>
extends LimaRecipeBuilder<R, B> {
    protected final List<SizedIngredient> itemIngredients = new ObjectArrayList();
    protected final List<SizedFluidIngredient> fluidIngredients = new ObjectArrayList();
    protected final List<ItemResult> itemResults = new ObjectArrayList();
    protected final List<FluidStack> fluidResults = new ObjectArrayList();

    public static <R extends LimaCustomRecipe<?>, B extends LimaCustomRecipeBuilder<R, B>> LimaCustomRecipeBuilder<R, B> simpleBuilder(ModResources resources, LimaCustomRecipe.RecipeFactory<R> factory) {
        return new SimpleBuilder(resources, factory);
    }

    public static <R extends LimaCustomRecipe<?>, B extends LimaCustomRecipeBuilder<R, B>> LimaCustomRecipeBuilder<R, B> simpleBuilder(ModResources resources, BiFunction<List<SizedIngredient>, List<ItemResult>, R> factory) {
        return LimaCustomRecipeBuilder.simpleBuilder(resources, (List<SizedIngredient> itemIngredients, List<SizedFluidIngredient> p2, List<ItemResult> itemResults, List<FluidStack> p4) -> (LimaCustomRecipe)factory.apply(itemIngredients, itemResults));
    }

    protected LimaCustomRecipeBuilder(ModResources modResources) {
        super(modResources);
    }

    public B input(SizedIngredient sizedIngredient) {
        this.itemIngredients.add(sizedIngredient);
        return (B)((LimaCustomRecipeBuilder)this.selfUnchecked());
    }

    public B input(Ingredient ingredient) {
        return this.input(new SizedIngredient(ingredient, 1));
    }

    public B randomInput(Ingredient child, float consumeChance) {
        return this.input(ConsumeChanceIngredient.of(child, consumeChance));
    }

    public B input(Ingredient ingredient, int count) {
        return this.input(new SizedIngredient(ingredient, count));
    }

    public B randomInput(Ingredient child, int count, float consumeChance) {
        return this.input(ConsumeChanceIngredient.of(child, consumeChance), count);
    }

    public B input(ItemLike itemLike) {
        return this.input(Ingredient.of((ItemLike[])new ItemLike[]{itemLike}));
    }

    public B input(ItemLike itemLike, int count) {
        return this.input(SizedIngredient.of((ItemLike)itemLike, (int)count));
    }

    public B randomInput(ItemLike itemLike, int count, float consumeChance) {
        return this.input(ConsumeChanceIngredient.of(Ingredient.of((ItemLike[])new ItemLike[]{itemLike}), consumeChance), count);
    }

    public B input(TagKey<Item> tagKey) {
        return this.input(Ingredient.of(tagKey));
    }

    public B input(TagKey<Item> tagKey, int count) {
        return this.input(SizedIngredient.of(tagKey, (int)count));
    }

    public B randomInput(TagKey<Item> tagKey, int count, float consumeChance) {
        return this.input(ConsumeChanceIngredient.of(Ingredient.of(tagKey), consumeChance), count);
    }

    public B fluidInput(SizedFluidIngredient ingredient) {
        this.fluidIngredients.add(ingredient);
        return (B)((LimaCustomRecipeBuilder)this.selfUnchecked());
    }

    public B fluidInput(FluidStack fluidStack) {
        return this.fluidInput(SizedFluidIngredient.of((FluidStack)fluidStack));
    }

    public B fluidInput(Fluid fluid, int amount) {
        return this.fluidInput(SizedFluidIngredient.of((Fluid)fluid, (int)amount));
    }

    public B fluidInput(Holder<Fluid> fluidHolder, int amount) {
        return this.fluidInput((Fluid)fluidHolder.value(), amount);
    }

    public B fluidInput(TagKey<Fluid> tagKey, int amount) {
        return this.fluidInput(SizedFluidIngredient.of(tagKey, (int)amount));
    }

    public B output(ItemResult result) {
        this.itemResults.add(result);
        return (B)((LimaCustomRecipeBuilder)this.selfUnchecked());
    }

    public B output(ItemStack stack, float chance) {
        return this.output(new ItemResult(stack, chance));
    }

    public B output(ItemStack stack) {
        return this.output(new ItemResult(stack));
    }

    public B output(ItemLike itemLike, int count, float chance) {
        return this.output(new ItemStack(itemLike, count), chance);
    }

    public B output(ItemLike itemLike, int count) {
        return this.output(new ItemStack(itemLike, count));
    }

    public B output(ItemLike itemLike) {
        return this.output(itemLike, 1);
    }

    public B fluidOutput(FluidStack fluidStack) {
        this.fluidResults.add(fluidStack);
        return (B)((LimaCustomRecipeBuilder)this.selfUnchecked());
    }

    public B fluidOutput(Fluid fluid, int amount) {
        return this.fluidOutput(new FluidStack(fluid, amount));
    }

    public B fluidOutput(Holder<Fluid> fluidHolder, int amount) {
        return this.fluidOutput(new FluidStack((Fluid)fluidHolder.value(), amount));
    }

    @Override
    protected String getDefaultRecipeName() {
        if (!this.itemResults.isEmpty()) {
            return LimaRegistryUtil.getItemName(this.itemResults.getFirst().item());
        }
        if (!this.fluidResults.isEmpty()) {
            return LimaRegistryUtil.getFluidName(this.fluidResults.getFirst());
        }
        throw new IllegalStateException("Default recipe name cannot be determined without any item or fluid results.");
    }

    private static class SimpleBuilder<R extends LimaCustomRecipe<?>, B extends LimaCustomRecipeBuilder<R, B>>
    extends LimaCustomRecipeBuilder<R, B> {
        private final LimaCustomRecipe.RecipeFactory<R> factory;

        private SimpleBuilder(ModResources modResources, LimaCustomRecipe.RecipeFactory<R> factory) {
            super(modResources);
            this.factory = factory;
        }

        @Override
        protected R buildRecipe() {
            return this.factory.create(this.itemIngredients, this.fluidIngredients, this.itemResults, this.fluidResults);
        }
    }
}

