/*
 * Decompiled with CFR 0.152.
 */
package liedge.limacore.data.generation.recipe;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import liedge.limacore.advancement.LimaAdvancementUtil;
import liedge.limacore.lib.ModResources;
import liedge.limacore.util.LimaRegistryUtil;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.conditions.ICondition;
import org.jetbrains.annotations.Nullable;

public abstract class LimaRecipeBuilder<R extends Recipe<?>, B extends LimaRecipeBuilder<R, B>>
implements RecipeBuilder {
    public static final String DEFAULT_CRITERION_KEY = "has_the_recipe";
    public static final AdvancementRequirements.Strategy HAS_RECIPE_OR_ALL_OF = keys -> {
        List<List> requirements = keys.stream().map(s -> List.of(s, DEFAULT_CRITERION_KEY)).toList();
        return new AdvancementRequirements(requirements);
    };
    private final List<ICondition> conditions = new ObjectArrayList();
    private final Map<String, Criterion<?>> criteria = new Object2ObjectOpenHashMap();
    protected final ModResources modResources;
    private String group;
    private AdvancementRequirements.Strategy strategy = AdvancementRequirements.Strategy.OR;

    protected LimaRecipeBuilder(ModResources modResources) {
        this.modResources = modResources;
    }

    public B condition(ICondition condition) {
        this.conditions.add(condition);
        return this.selfUnchecked();
    }

    public B unlockedBy(String criterionKey, Criterion<?> criterion) {
        this.criteria.putIfAbsent(criterionKey, criterion);
        return this.selfUnchecked();
    }

    public B unlockedBy(ItemLike item) {
        String name = "has_" + LimaRegistryUtil.getItemName(item.asItem());
        return (B)this.unlockedBy(name, InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{item}));
    }

    public B unlockedBy(TagKey<Item> tag) {
        String name = "has_any_" + tag.location().getPath().replace("/", "_");
        return (B)this.unlockedBy(name, (Criterion)LimaAdvancementUtil.playerHasItems(tag));
    }

    public B unlockStrategy(AdvancementRequirements.Strategy strategy) {
        this.strategy = strategy;
        return this.selfUnchecked();
    }

    protected abstract R buildRecipe();

    protected abstract String getDefaultRecipeName();

    protected final B selfUnchecked() {
        return (B)this;
    }

    @Deprecated
    public final Item getResult() {
        throw new UnsupportedOperationException("Use getDefaultRecipeName instead");
    }

    public B group(@Nullable String group) {
        this.group = group;
        return this.selfUnchecked();
    }

    @Nullable
    public String getGroup() {
        return this.group;
    }

    public String getGroupOrBlank() {
        return Objects.requireNonNullElse(this.getGroup(), "");
    }

    protected String makeTypePrefix(Recipe<?> recipe) {
        return LimaRegistryUtil.getNonNullRegistryId(recipe.getType(), BuiltInRegistries.RECIPE_TYPE).getPath() + "/";
    }

    protected String makeSerializerPrefix(Recipe<?> recipe) {
        return LimaRegistryUtil.getNonNullRegistryId(recipe.getSerializer(), BuiltInRegistries.RECIPE_SERIALIZER).getPath() + "/";
    }

    protected String defaultFolderPrefix(R recipe, ResourceLocation recipeId) {
        return this.makeSerializerPrefix((Recipe<?>)recipe);
    }

    @Nullable
    protected AdvancementHolder buildAdvancement(Advancement.Builder builder, ResourceLocation id, Map<String, Criterion<?>> criteria) {
        if (criteria.isEmpty()) {
            return null;
        }
        builder.addCriterion(DEFAULT_CRITERION_KEY, RecipeUnlockedTrigger.unlocked((ResourceLocation)id)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)id)).requirements(this.strategy);
        criteria.forEach((arg_0, arg_1) -> ((Advancement.Builder)builder).addCriterion(arg_0, arg_1));
        return builder.build(id.withPrefix("recipes/"));
    }

    private void save(RecipeOutput recipeOutput, ResourceLocation id, boolean appendFolderPrefix) {
        R recipe = this.buildRecipe();
        if (appendFolderPrefix) {
            id = id.withPrefix(this.defaultFolderPrefix(recipe, id));
        }
        AdvancementHolder advancement = this.buildAdvancement(recipeOutput.advancement(), id, this.criteria);
        recipeOutput.accept(id, recipe, advancement, (ICondition[])this.conditions.toArray(ICondition[]::new));
    }

    public final void save(RecipeOutput recipeOutput, ResourceLocation id) {
        this.save(recipeOutput, id, false);
    }

    public final void save(RecipeOutput recipeOutput, String name) {
        this.save(recipeOutput, this.modResources.location(name), true);
    }

    public final void save(RecipeOutput recipeOutput) {
        this.save(recipeOutput, this.getDefaultRecipeName());
    }
}

