/*
 * Decompiled with CFR 0.152.
 */
package liedge.limacore.data.generation.recipe;

import it.unimi.dsi.fastutil.chars.Char2ObjectMap;
import it.unimi.dsi.fastutil.chars.Char2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import liedge.limacore.data.generation.recipe.LimaRecipeBuilder;
import liedge.limacore.lib.ModResources;
import liedge.limacore.util.LimaRegistryUtil;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.level.ItemLike;

public class LimaShapedRecipeBuilder
extends LimaRecipeBuilder<ShapedRecipe, LimaShapedRecipeBuilder> {
    private final List<String> rows = new ObjectArrayList();
    private final Char2ObjectMap<Ingredient> ingredients = new Char2ObjectOpenHashMap();
    private final ItemStack resultItem;
    private CraftingBookCategory category = CraftingBookCategory.MISC;
    private boolean showNotification = true;

    public LimaShapedRecipeBuilder(ModResources resources, ItemStack resultItem) {
        super(resources);
        this.resultItem = resultItem;
    }

    public LimaShapedRecipeBuilder patterns(String ... patterns) {
        for (String p : patterns) {
            if (!this.rows.isEmpty() && p.length() != this.rows.getFirst().length()) {
                throw new IllegalArgumentException("Pattern must be the same width on every line!");
            }
            this.rows.add(p);
        }
        return this;
    }

    public LimaShapedRecipeBuilder input(char key, Ingredient ingredient) {
        this.ingredients.put(key, (Object)ingredient);
        return this;
    }

    public LimaShapedRecipeBuilder input(char key, ItemLike item) {
        return this.input(key, Ingredient.of((ItemLike[])new ItemLike[]{item}));
    }

    public LimaShapedRecipeBuilder input(char key, TagKey<Item> itemTag) {
        return this.input(key, Ingredient.of(itemTag));
    }

    public LimaShapedRecipeBuilder showsNotification(boolean showNotification) {
        this.showNotification = showNotification;
        return this;
    }

    public LimaShapedRecipeBuilder bookCategory(CraftingBookCategory category) {
        this.category = category;
        return this;
    }

    @Override
    protected String defaultFolderPrefix(ShapedRecipe recipe, ResourceLocation recipeId) {
        return "shaped_recipes/";
    }

    @Override
    protected ShapedRecipe buildRecipe() {
        ShapedRecipePattern pattern = ShapedRecipePattern.of(this.ingredients, this.rows);
        return new ShapedRecipe(this.getGroupOrBlank(), this.category, pattern, this.resultItem, this.showNotification);
    }

    @Override
    protected String getDefaultRecipeName() {
        return LimaRegistryUtil.getItemName(this.resultItem);
    }
}

