/*
 * Decompiled with CFR 0.152.
 */
package liedge.limacore.lib;

import liedge.limacore.data.LimaEnumCodec;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.StringRepresentable;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;

public enum MobHostility implements StringRepresentable
{
    PASSIVE("passive"),
    NEUTRAL_MOB("neutral_mob"),
    NEUTRAL_ENEMY("neutral_enemy"),
    HOSTILE("hostile");

    public static final LimaEnumCodec<MobHostility> CODEC;
    public static final StreamCodec<FriendlyByteBuf, MobHostility> STREAM_CODEC;
    private final String name;

    private MobHostility(String name) {
        this.name = name;
    }

    public String getSerializedName() {
        return this.name;
    }

    public boolean atMost(MobHostility other) {
        return this.compareTo(other) <= 0;
    }

    public boolean atLeast(MobHostility other) {
        return this.compareTo(other) >= 0;
    }

    public boolean between(MobHostility min, MobHostility max) {
        return this.atLeast(min) && this.atMost(max);
    }

    static {
        CODEC = LimaEnumCodec.create(MobHostility.class);
        STREAM_CODEC = NeoForgeStreamCodecs.enumCodec(MobHostility.class);
    }
}

