/*
 * Decompiled with CFR 0.152.
 */
package liedge.limacore.lib;

import java.util.Arrays;
import liedge.limacore.lib.Translatable;
import liedge.limacore.registry.LimaDeferredAttributes;
import liedge.limacore.registry.LimaDeferredBlocksWithItems;
import liedge.limacore.registry.LimaDeferredNetworkSerializers;
import liedge.limacore.registry.LimaDeferredRecipeSerializers;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.RegistryBuilder;
import org.apache.commons.lang3.StringUtils;

public record ModResources(String modid) {
    public static final ModResources COMMON = new ModResources("c");
    public static final ModResources NEOFORGE = new ModResources("neoforge");
    public static final ModResources MC = new ModResources("minecraft");

    private static String joinComponents(char delimiter, String ... components) {
        return Arrays.stream(components).filter(StringUtils::isNotBlank).reduce((s1, s2) -> s1 + delimiter + s2).orElseThrow(() -> new IllegalArgumentException("Path must have at least 1 non-blank component."));
    }

    public static String idLangKey(ResourceLocation id) {
        return ModResources.idLangKey(id, "{n}.{p}");
    }

    public static String idLangKey(ResourceLocation id, String keyTemplate) {
        return keyTemplate.replace("{n}", id.getNamespace()).replace("{p}", id.getPath()).replace('/', '.');
    }

    public static String idLangKey(ResourceLocation id, String ... keyComponents) {
        return ModResources.idLangKey(id, ModResources.joinComponents('.', keyComponents));
    }

    public static String prefixedIdLangKey(String prefix, ResourceLocation id) {
        return ModResources.idLangKey(id, prefix, "{n}.{p}");
    }

    public static String registryPrefixedIdLangKey(ResourceKey<?> key) {
        return ModResources.prefixedIdLangKey(key.registry().getPath(), key.location());
    }

    public static String prefixedVariantIdLangKey(String prefix, String suffix, ResourceLocation id) {
        return ModResources.idLangKey(id, prefix, "{n}.{p}", suffix);
    }

    public static String registryPrefixVariantIdLangKey(ResourceKey<?> key, String suffix) {
        return ModResources.prefixedVariantIdLangKey(key.registry().getPath(), suffix, key.location());
    }

    public <T> ResourceKey<T> resourceKey(ResourceKey<? extends Registry<T>> registryKey, String name) {
        return ResourceKey.create(registryKey, (ResourceLocation)this.location(name));
    }

    public <T> ResourceKey<Registry<T>> registryResourceKey(String name) {
        return ResourceKey.createRegistryKey((ResourceLocation)this.location(name));
    }

    public <T> DeferredRegister<T> deferredRegister(Registry<T> registry) {
        return DeferredRegister.create(registry, (String)this.modid);
    }

    public <T> DeferredRegister<T> deferredRegister(ResourceKey<? extends Registry<T>> registryKey) {
        return DeferredRegister.create(registryKey, (String)this.modid);
    }

    public <T> DeferredRegister<T> deferredRegister(String registryName) {
        return DeferredRegister.create(this.registryResourceKey(registryName), (String)this.modid);
    }

    public DeferredRegister.Items deferredItems() {
        return DeferredRegister.createItems((String)this.modid);
    }

    public DeferredRegister.Blocks deferredBlocks() {
        return DeferredRegister.createBlocks((String)this.modid);
    }

    public LimaDeferredBlocksWithItems deferredBlocksWithItems() {
        return LimaDeferredBlocksWithItems.create(this.modid);
    }

    public DeferredRegister.DataComponents deferredDataComponents(ResourceKey<Registry<DataComponentType<?>>> componentRegistryKey) {
        return DeferredRegister.DataComponents.createDataComponents(componentRegistryKey, (String)this.modid);
    }

    public DeferredRegister.DataComponents deferredDataComponents() {
        return this.deferredDataComponents(Registries.DATA_COMPONENT_TYPE);
    }

    public LimaDeferredRecipeSerializers deferredRecipeSerializers() {
        return LimaDeferredRecipeSerializers.create(this.modid);
    }

    public LimaDeferredAttributes deferredAttributes() {
        return LimaDeferredAttributes.create(this.modid);
    }

    public LimaDeferredNetworkSerializers deferredNetworkSerializers() {
        return LimaDeferredNetworkSerializers.create(this.modid);
    }

    public <T> RegistryBuilder<T> registryBuilder(ResourceKey<? extends Registry<T>> registryKey) {
        return new RegistryBuilder(registryKey);
    }

    public <T> RegistryBuilder<T> registryBuilder(String registryName) {
        return this.registryBuilder(this.registryResourceKey(registryName));
    }

    public <T> TagKey<T> tagKey(ResourceKey<? extends Registry<T>> registryKey, String name) {
        return TagKey.create(registryKey, (ResourceLocation)this.location(name));
    }

    public TagKey<Block> blockTag(String name) {
        return BlockTags.create((ResourceLocation)this.location(name));
    }

    public TagKey<Item> itemTag(String name) {
        return ItemTags.create((ResourceLocation)this.location(name));
    }

    public TagKey<Fluid> fluidTag(String name) {
        return FluidTags.create((ResourceLocation)this.location(name));
    }

    public TagKey<BlockEntityType<?>> blockEntityTag(String name) {
        return this.tagKey(Registries.BLOCK_ENTITY_TYPE, name);
    }

    public TagKey<EntityType<?>> entityTypeTag(String name) {
        return this.tagKey(Registries.ENTITY_TYPE, name);
    }

    public TagKey<DamageType> damageTypeTag(String name) {
        return this.tagKey(Registries.DAMAGE_TYPE, name);
    }

    public ResourceLocation location(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)this.modid, (String)path);
    }

    public ResourceLocation extensionLocation(String path, String extension) {
        return this.location(path + "." + extension);
    }

    public ResourceLocation formatLocation(String ... components) {
        return this.location(this.joinModComponents('/', components));
    }

    public ResourceLocation formatExtensionLocation(String extension, String ... components) {
        return this.extensionLocation(this.joinModComponents('/', components), extension);
    }

    public ResourceLocation textureLocation(String folder, String path) {
        return this.formatExtensionLocation("png", "textures", folder, path);
    }

    public Translatable translationHolder(String key) {
        return Translatable.standalone(this.translationKey(key));
    }

    public Translatable translationHolder(String ... keyComponents) {
        return Translatable.standalone(this.translationKey(keyComponents));
    }

    public String translationKey(String key) {
        return key.replace("{}", this.modid).replace("/", ".");
    }

    public String translationKey(String ... keyComponents) {
        String key = this.joinModComponents('.', keyComponents);
        return key.replace("/", ".");
    }

    private String joinModComponents(char delimiter, String ... components) {
        return ModResources.joinComponents(delimiter, components).replace("{}", this.modid);
    }

    public <T extends CustomPacketPayload> CustomPacketPayload.Type<T> packetType(String name) {
        return new CustomPacketPayload.Type(this.location(name));
    }
}

