/*
 * Decompiled with CFR 0.152.
 */
package liedge.limacore.lib;

import java.util.Objects;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public interface Translatable {
    public static Translatable standalone(String descriptionId) {
        return new TranslationHolder(descriptionId);
    }

    public String descriptionId();

    default public MutableComponent translate() {
        return Component.translatable((String)this.descriptionId());
    }

    default public MutableComponent translateArgs(Object ... args) {
        return Component.translatable((String)this.descriptionId(), (Object[])args);
    }

    public record TranslationHolder(String descriptionId) implements Translatable
    {
        @Override
        public String toString() {
            return this.descriptionId;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Translatable) {
                Translatable translatable = (Translatable)obj;
                return Objects.equals(this.descriptionId, translatable.descriptionId());
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.descriptionId.hashCode();
        }
    }
}

