/*
 * Decompiled with CFR 0.152.
 */
package liedge.limacore.lib.math;

import java.util.Comparator;
import java.util.List;
import java.util.function.DoubleBinaryOperator;
import java.util.function.Function;
import liedge.limacore.data.LimaEnumCodec;
import net.minecraft.util.StringRepresentable;

public enum MathOperation implements StringRepresentable,
DoubleBinaryOperator
{
    IDENTITY("identity", 0),
    REPLACE("replace", 1),
    ADD("add", 2),
    MULTIPLY("multiply", 10),
    DIVIDE("divide", 10),
    MAX("max", 3),
    MIN("min", 3),
    MULTIPLY_AND_ADD("multiply_and_add", 4),
    ADD_PERCENT_OF_BASE("add_percent_of_base", 4),
    ADD_PERCENT_OF_TOTAL("add_percent_of_total", 5);

    public static final LimaEnumCodec<MathOperation> SINGLE_OP_CODEC;
    public static final LimaEnumCodec<MathOperation> COMPOUND_OP_CODEC;
    public static final Comparator<MathOperation> PRIORITY_COMPARATOR;
    private final String name;
    private final int priority;

    public static Comparator<MathOperation> comparingPriority() {
        return PRIORITY_COMPARATOR;
    }

    public static <T> Comparator<T> comparingPriority(Function<? super T, MathOperation> opAccessor) {
        return Comparator.comparing(opAccessor, PRIORITY_COMPARATOR);
    }

    private MathOperation(String name, int priority) {
        this.name = name;
        this.priority = priority;
    }

    public int getPriority() {
        return this.priority;
    }

    @Override
    public double applyAsDouble(double left, double right) {
        return switch (this.ordinal()) {
            case 2 -> left + right;
            case 3 -> left * right;
            case 7 -> left + left * right;
            case 4 -> {
                if (right != 0.0) {
                    yield left / right;
                }
                yield 0.0;
            }
            case 5 -> Math.max(left, right);
            case 6 -> Math.min(left, right);
            case 0 -> left;
            case 1 -> right;
            default -> throw new UnsupportedOperationException("The operation " + this.getSerializedName() + " is not supported for single operations.");
        };
    }

    public double applyCompoundingDouble(double total, double base, double operand) {
        return switch (this.ordinal()) {
            case 0 -> total;
            case 1 -> operand;
            case 2 -> total + operand;
            case 8 -> total + base * operand;
            case 9 -> total + total * operand;
            case 3 -> total * operand;
            case 4 -> {
                if (operand != 0.0) {
                    yield total / operand;
                }
                yield 0.0;
            }
            default -> throw new UnsupportedOperationException("The operation " + this.getSerializedName() + " is not supported for compound operations.");
        };
    }

    public String getSerializedName() {
        return this.name;
    }

    static {
        SINGLE_OP_CODEC = LimaEnumCodec.create(MathOperation.class, List.of(IDENTITY, REPLACE, ADD, MULTIPLY_AND_ADD, MULTIPLY, DIVIDE, MAX, MIN));
        COMPOUND_OP_CODEC = LimaEnumCodec.create(MathOperation.class, List.of(IDENTITY, REPLACE, ADD, ADD_PERCENT_OF_BASE, ADD_PERCENT_OF_TOTAL, MULTIPLY, DIVIDE));
        PRIORITY_COMPARATOR = Comparator.comparingInt(MathOperation::getPriority);
    }
}

