/*
 * Decompiled with CFR 0.152.
 */
package liedge.limacore.menu;

import java.util.Objects;
import liedge.limacore.blockentity.LimaBlockEntityAccess;
import liedge.limacore.lib.Translatable;
import liedge.limacore.menu.LimaMenu;
import liedge.limacore.menu.LimaMenuType;
import liedge.limacore.util.LimaBlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelReader;
import org.jetbrains.annotations.Nullable;

public class BlockEntityMenuType<BE extends LimaBlockEntityAccess, M extends LimaMenu<BE>>
extends LimaMenuType<BE, M> {
    public static <BE extends LimaBlockEntityAccess, M extends LimaMenu<BE>> BlockEntityMenuType<BE, M> create(Class<BE> contextClass, LimaMenuType.MenuFactory<BE, M> factory, @Nullable Translatable defaultTitle) {
        return new BlockEntityMenuType<BE, M>(contextClass, factory, defaultTitle);
    }

    public static <BE extends LimaBlockEntityAccess, M extends LimaMenu<BE>> BlockEntityMenuType<BE, M> create(ResourceLocation id, Class<BE> contextClass, LimaMenuType.MenuFactory<BE, M> factory) {
        return BlockEntityMenuType.create(contextClass, factory, BlockEntityMenuType.defaultMenuTitle(id));
    }

    public static <BE extends LimaBlockEntityAccess, M extends LimaMenu<BE>> BlockEntityMenuType<BE, M> create(Class<BE> contextClass, LimaMenuType.MenuFactory<BE, M> factory) {
        return BlockEntityMenuType.create(contextClass, factory, null);
    }

    private BlockEntityMenuType(Class<BE> contextClass, LimaMenuType.MenuFactory<BE, M> factory, @Nullable Translatable defaultTitle) {
        super(contextClass, factory, defaultTitle);
    }

    @Override
    public void encodeContext(BE menuContext, RegistryFriendlyByteBuf net) {
        net.writeBlockPos(menuContext.getAsLimaBlockEntity().getBlockPos());
    }

    @Override
    protected BE decodeContext(RegistryFriendlyByteBuf net, Inventory inventory) {
        BlockPos pos = net.readBlockPos();
        return (BE)Objects.requireNonNull((LimaBlockEntityAccess)LimaBlockUtil.getSafeBlockEntity((LevelReader)inventory.player.level(), pos, this.getContextClass()));
    }

    @Override
    public boolean canPlayerKeepUsing(BE menuContext, Player player) {
        return menuContext.getAsLimaBlockEntity().canPlayerUse(player);
    }
}

