/*
 * Decompiled with CFR 0.152.
 */
package liedge.limacore.menu.slot;

import liedge.limacore.advancement.CustomRecipeTypeTrigger;
import liedge.limacore.menu.slot.LimaHandlerSlot;
import liedge.limacore.registry.game.LimaCoreTriggerTypes;
import liedge.limacore.util.LimaItemUtil;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.neoforged.neoforge.items.IItemHandlerModifiable;

public class RecipeOutputSlot
extends LimaHandlerSlot {
    private final Player player;
    private final RecipeType<?> recipeType;
    private int removeCount = 0;

    public RecipeOutputSlot(IItemHandlerModifiable itemHandler, int slotIndex, int xPos, int yPos, Player player, RecipeType<?> recipeType) {
        super(itemHandler, slotIndex, xPos, yPos, false, LimaItemUtil.ALWAYS_FALSE);
        this.player = player;
        this.recipeType = recipeType;
    }

    @Override
    public boolean reverseQuickTransfer() {
        return true;
    }

    public ItemStack remove(int amount) {
        if (this.hasItem()) {
            this.removeCount += Math.min(amount, this.getItem().getCount());
        }
        return super.remove(amount);
    }

    public void onTake(Player player, ItemStack stack) {
        this.checkTakeAchievements(stack);
        super.onTake(player, stack);
    }

    public void onQuickCraft(ItemStack oldStack, ItemStack newStack) {
        int i = newStack.getCount() - oldStack.getCount();
        if (i > 0) {
            this.onQuickCraft(newStack, i);
        }
    }

    protected void onQuickCraft(ItemStack stack, int amount) {
        this.removeCount += amount;
        this.checkTakeAchievements(stack);
    }

    protected void checkTakeAchievements(ItemStack stack) {
        if (this.removeCount > 0) {
            stack.onCraftedBy(this.player.level(), this.player, this.removeCount);
            Player player = this.player;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ((CustomRecipeTypeTrigger)((Object)LimaCoreTriggerTypes.CUSTOM_RECIPE_TYPE_USED.get())).trigger(serverPlayer, this.recipeType, stack);
            }
            this.removeCount = 0;
        }
    }
}

