/*
 * Decompiled with CFR 0.152.
 */
package liedge.limacore.network;

import java.util.List;
import liedge.limacore.LimaCore;
import liedge.limacore.network.NetworkSerializer;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import org.jetbrains.annotations.Nullable;

public record IndexedStreamData<T>(int index, NetworkSerializer<T> serializer, T data) {
    public static final StreamCodec<RegistryFriendlyByteBuf, IndexedStreamData<?>> STREAM_CODEC = StreamCodec.of((net, obj) -> obj.encode((RegistryFriendlyByteBuf)net), IndexedStreamData::decode);
    public static final StreamCodec<RegistryFriendlyByteBuf, List<IndexedStreamData<?>>> LIST_STREAM_CODEC = STREAM_CODEC.apply(ByteBufCodecs.list());

    private static <T> IndexedStreamData<T> decode(RegistryFriendlyByteBuf net) {
        int index = net.readVarInt();
        NetworkSerializer serializer = (NetworkSerializer)NetworkSerializer.REGISTRY_STREAM_CODEC.decode((Object)net);
        Object data = serializer.decode(net);
        return new IndexedStreamData(index, serializer, data);
    }

    private void encode(RegistryFriendlyByteBuf net) {
        net.writeVarInt(this.index);
        NetworkSerializer.REGISTRY_STREAM_CODEC.encode((Object)net, this.serializer);
        this.serializer.encode(net, this.data);
    }

    @Nullable
    public <A> A tryCast(NetworkSerializer<A> other) {
        if (other == this.serializer) {
            return (A)this.data;
        }
        LimaCore.LOGGER.warn("Attempted to access decoded data with mismatching serializers. Expected {} but received {}.", (Object)other.id(), (Object)this.serializer.id());
        return null;
    }
}

