/*
 * Decompiled with CFR 0.152.
 */
package liedge.limacore.network.sync;

import java.util.function.Consumer;
import java.util.function.Supplier;
import liedge.limacore.client.LimaCoreClientUtil;
import liedge.limacore.network.NetworkSerializer;
import liedge.limacore.network.sync.LimaDataWatcher;
import liedge.limacore.registry.game.LimaCoreNetworkSerializers;
import liedge.limacore.util.LimaCollectionsUtil;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public sealed class AutomaticDataWatcher<T>
extends LimaDataWatcher<T> {
    private final Supplier<T> getter;
    private final Consumer<T> setter;
    private T previousData;

    public static <T> LimaDataWatcher<T> keepSynced(NetworkSerializer<T> serializer, Supplier<T> getter, Consumer<T> setter) {
        return new AutomaticDataWatcher<T>(serializer, getter, setter);
    }

    public static <T> LimaDataWatcher<T> keepSynced(Supplier<? extends NetworkSerializer<T>> supplier, Supplier<T> getter, Consumer<T> setter) {
        return new AutomaticDataWatcher<T>(supplier.get(), getter, setter);
    }

    public static <E extends Enum<E>> LimaDataWatcher<Integer> keepEnumSynced(Class<E> enumClass, Supplier<E> getter, Consumer<E> setter) {
        return new AutomaticDataWatcher<Integer>((NetworkSerializer)LimaCoreNetworkSerializers.VAR_INT.get(), () -> ((Enum)getter.get()).ordinal(), ordinal -> setter.accept(LimaCollectionsUtil.getEnumByOrdinal(enumClass, ordinal)));
    }

    public static LimaDataWatcher<ItemStack> keepItemSynced(Supplier<ItemStack> getter, Consumer<ItemStack> setter) {
        return new ItemWatcher(getter, setter);
    }

    public static LimaDataWatcher<Integer> keepClientsideEntitySynced(Supplier<@Nullable Entity> getter, Consumer<@Nullable Entity> setter) {
        return AutomaticDataWatcher.keepSynced(LimaCoreNetworkSerializers.VAR_INT, () -> {
            Entity entity = (Entity)getter.get();
            return entity != null && !entity.isRemoved() ? entity.getId() : -1;
        }, (T eid) -> setter.accept(LimaCoreClientUtil.getClientEntity(eid)));
    }

    private AutomaticDataWatcher(NetworkSerializer<T> serializer, Supplier<T> getter, Consumer<T> setter) {
        super(serializer);
        this.getter = getter;
        this.setter = setter;
    }

    protected boolean areDataValuesEqual(T previousData, T currentData) {
        return previousData.equals(currentData);
    }

    private boolean checkForChanges() {
        if (this.previousData == null) {
            this.previousData = this.getCurrentData();
            return true;
        }
        T currentData = this.getCurrentData();
        if (!this.areDataValuesEqual(this.previousData, currentData)) {
            this.previousData = currentData;
            return true;
        }
        return false;
    }

    @Override
    protected T getCurrentData() {
        return this.getter.get();
    }

    @Override
    protected void setCurrentData(T currentData) {
        this.setter.accept(currentData);
    }

    @Override
    protected boolean tick() {
        if (this.checkForChanges()) {
            this.setChanged(true);
        }
        return super.tick();
    }

    static final class ItemWatcher
    extends AutomaticDataWatcher<ItemStack> {
        private ItemWatcher(Supplier<ItemStack> getter, Consumer<ItemStack> setter) {
            super((NetworkSerializer)LimaCoreNetworkSerializers.ITEM_STACK.get(), getter, setter);
        }

        @Override
        protected ItemStack getCurrentData() {
            return ((ItemStack)super.getCurrentData()).copy();
        }

        @Override
        protected boolean areDataValuesEqual(ItemStack previousData, ItemStack currentData) {
            return ItemStack.matches((ItemStack)previousData, (ItemStack)currentData);
        }
    }
}

