/*
 * Decompiled with CFR 0.152.
 */
package liedge.limacore.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import liedge.limacore.data.EmptyFieldMapCodec;
import liedge.limacore.data.LimaCoreCodecs;
import liedge.limacore.network.LimaStreamCodecs;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;

public record ItemResult(ItemStack item, float chance) {
    private static final String MAP_CODEC_KEY = "item_results";
    public static final Codec<ItemResult> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)LimaCoreCodecs.ITEM_STACK_MAP_CODEC.forGetter(ItemResult::item), (App)LimaCoreCodecs.floatOpenStartRange(0.0f, 1.0f).optionalFieldOf("chance", (Object)Float.valueOf(1.0f)).forGetter(ItemResult::chance)).apply((Applicative)instance, ItemResult::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemResult> STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemStack.STREAM_CODEC, ItemResult::item, (StreamCodec)ByteBufCodecs.FLOAT, ItemResult::chance, ItemResult::new);
    public static final MapCodec<List<ItemResult>> LIST_UNIT_MAP_CODEC = EmptyFieldMapCodec.emptyListField("item_results");
    public static final StreamCodec<RegistryFriendlyByteBuf, List<ItemResult>> LIST_UNIT_STREAM_CODEC = StreamCodec.unit(List.of());

    public ItemResult(ItemStack item) {
        this(item, 1.0f);
    }

    public static MapCodec<List<ItemResult>> listMapCodec(int min, int max) {
        return LimaCoreCodecs.smartSizedListField(CODEC, MAP_CODEC_KEY, min, max);
    }

    public static StreamCodec<RegistryFriendlyByteBuf, List<ItemResult>> listStreamCodec(int min, int max) {
        return STREAM_CODEC.apply(LimaStreamCodecs.asClampedList(min, max));
    }

    public ItemStack generateResult(RandomSource random) {
        if (this.chance == 1.0f || random.nextFloat() <= this.chance) {
            return this.item.copy();
        }
        return ItemStack.EMPTY;
    }
}

