/*
 * Decompiled with CFR 0.152.
 */
package liedge.limacore.recipe;

import java.util.Optional;
import java.util.function.Supplier;
import liedge.limacore.LimaCore;
import liedge.limacore.network.sync.AutomaticDataWatcher;
import liedge.limacore.network.sync.LimaDataWatcher;
import liedge.limacore.registry.game.LimaCoreNetworkSerializers;
import liedge.limacore.util.LimaRecipesUtil;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.StringTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.util.INBTSerializable;
import org.jetbrains.annotations.Nullable;

public final class LimaRecipeCheck<I extends RecipeInput, R extends Recipe<I>>
implements RecipeManager.CachedCheck<I, R>,
INBTSerializable<StringTag> {
    private static final String NULL_MARKER = "null";
    private final RecipeType<R> recipeType;
    @Nullable
    private ResourceLocation lastUsedId;

    public static <I extends RecipeInput, R extends Recipe<I>> LimaRecipeCheck<I, R> create(RecipeType<R> type) {
        return new LimaRecipeCheck<I, R>(type);
    }

    public static <I extends RecipeInput, R extends Recipe<I>> LimaRecipeCheck<I, R> create(Supplier<? extends RecipeType<R>> typeSupplier) {
        return new LimaRecipeCheck<I, R>(typeSupplier.get());
    }

    private LimaRecipeCheck(RecipeType<R> recipeType) {
        this.recipeType = recipeType;
    }

    public RecipeType<R> getRecipeType() {
        return this.recipeType;
    }

    public Optional<RecipeHolder<R>> getRecipeFor(I input, Level level) {
        Optional optional = level.getRecipeManager().getRecipeFor(this.recipeType, input, level, this.lastUsedId);
        optional.ifPresent(holder -> {
            this.lastUsedId = holder.id();
        });
        return optional;
    }

    public Optional<RecipeHolder<R>> getLastUsedRecipe(@Nullable Level level) {
        if (level == null || this.lastUsedId == null) {
            return Optional.empty();
        }
        return LimaRecipesUtil.getRecipeById(level, this.lastUsedId, this.recipeType);
    }

    public void setLastUsedRecipe(@Nullable RecipeHolder<R> recipe) {
        this.lastUsedId = recipe != null ? recipe.id() : null;
    }

    public LimaDataWatcher<String> createDataWatcher() {
        return AutomaticDataWatcher.keepSynced(LimaCoreNetworkSerializers.STRING_UTF8, this::serialize, this::deserialize);
    }

    public StringTag serializeNBT(HolderLookup.Provider provider) {
        return StringTag.valueOf((String)this.serialize());
    }

    public void deserializeNBT(HolderLookup.Provider provider, StringTag nbt) {
        this.deserialize(nbt.getAsString());
    }

    private String serialize() {
        return this.lastUsedId != null ? this.lastUsedId.toString() : NULL_MARKER;
    }

    private void deserialize(String value) {
        try {
            this.lastUsedId = !value.equals(NULL_MARKER) ? ResourceLocation.parse((String)value) : null;
        }
        catch (ResourceLocationException ex) {
            LimaCore.LOGGER.warn("Tried to deserialize invalid recipe ID '{}'.", (Object)value);
            this.lastUsedId = null;
        }
    }
}

