/*
 * Decompiled with CFR 0.152.
 */
package liedge.limacore.recipe;

import java.util.List;
import java.util.Objects;
import liedge.limacore.capability.fluid.LimaFluidHandler;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeInput;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public interface LimaRecipeInput
extends RecipeInput {
    public static LimaRecipeInput create(@Nullable IItemHandler itemContainer, @Nullable LimaFluidHandler fluidContainer) {
        return switch (Objects.isNull(itemContainer) + "," + Objects.isNull(fluidContainer)) {
            case "false,false" -> LimaRecipeInput.of(itemContainer, fluidContainer);
            case "false,true" -> LimaRecipeInput.of(itemContainer);
            case "true,false" -> LimaRecipeInput.of(fluidContainer);
            default -> EmptyInput.INSTANCE;
        };
    }

    public static LimaRecipeInput of(IItemHandler itemContainer) {
        return new ItemsOnly(itemContainer);
    }

    public static LimaRecipeInput of(LimaFluidHandler fluidContainer) {
        return new FluidsOnly(fluidContainer);
    }

    public static LimaRecipeInput of(IItemHandler itemContainer, LimaFluidHandler fluidContainer) {
        return new ItemsAndFluids(itemContainer, fluidContainer);
    }

    public ItemStack extractItem(int var1, int var2, boolean var3);

    public FluidStack extractFluid(int var1, int var2, IFluidHandler.FluidAction var3);

    public FluidStack getFluid(int var1);

    public int tanks();

    default public boolean isEmpty() {
        return this.areItemsEmpty() && this.areFluidsEmpty();
    }

    default public boolean areItemsEmpty() {
        return super.isEmpty();
    }

    default public boolean areFluidsEmpty() {
        for (int i = 0; i < this.tanks(); ++i) {
            if (this.getFluid(i).isEmpty()) continue;
            return false;
        }
        return true;
    }

    default public boolean checkItemInputSize(List<SizedIngredient> itemIngredients) {
        return itemIngredients.isEmpty() || itemIngredients.size() <= this.size() && !this.isEmpty();
    }

    default public boolean checkFluidInputSize(List<SizedFluidIngredient> fluidIngredients) {
        return fluidIngredients.isEmpty() || fluidIngredients.size() <= this.tanks() && !this.areFluidsEmpty();
    }

    public static final class EmptyInput
    implements LimaRecipeInput {
        private static final EmptyInput INSTANCE = new EmptyInput();

        private EmptyInput() {
        }

        @Override
        public ItemStack extractItem(int slot, int count, boolean simulate) {
            return ItemStack.EMPTY;
        }

        @Override
        public FluidStack extractFluid(int tank, int amount, IFluidHandler.FluidAction action) {
            return FluidStack.EMPTY;
        }

        @Override
        public FluidStack getFluid(int tank) {
            return FluidStack.EMPTY;
        }

        @Override
        public int tanks() {
            return 0;
        }

        public ItemStack getItem(int index) {
            return ItemStack.EMPTY;
        }

        public int size() {
            return 0;
        }
    }

    public record ItemsOnly(IItemHandler itemContainer) implements ItemContainerSource
    {
        @Override
        public FluidStack extractFluid(int tank, int amount, IFluidHandler.FluidAction action) {
            return FluidStack.EMPTY;
        }

        @Override
        public FluidStack getFluid(int tank) {
            return FluidStack.EMPTY;
        }

        @Override
        public int tanks() {
            return 0;
        }
    }

    public record FluidsOnly(LimaFluidHandler fluidContainer) implements FluidContainerSource
    {
        @Override
        public ItemStack extractItem(int slot, int count, boolean simulate) {
            return ItemStack.EMPTY;
        }

        public ItemStack getItem(int index) {
            return ItemStack.EMPTY;
        }

        public int size() {
            return 0;
        }
    }

    public record ItemsAndFluids(IItemHandler itemContainer, LimaFluidHandler fluidContainer) implements ItemContainerSource,
    FluidContainerSource
    {
    }

    public static interface FluidContainerSource
    extends LimaRecipeInput {
        public LimaFluidHandler fluidContainer();

        @Override
        default public FluidStack extractFluid(int tank, int amount, IFluidHandler.FluidAction action) {
            return this.fluidContainer().drainTank(tank, amount, action, true);
        }

        @Override
        default public FluidStack getFluid(int tank) {
            return this.fluidContainer().getFluidInTank(tank);
        }

        @Override
        default public int tanks() {
            return this.fluidContainer().getTanks();
        }
    }

    public static interface ItemContainerSource
    extends LimaRecipeInput {
        public IItemHandler itemContainer();

        @Override
        default public ItemStack extractItem(int slot, int count, boolean simulate) {
            return this.itemContainer().extractItem(slot, count, simulate);
        }

        default public ItemStack getItem(int index) {
            return this.itemContainer().getStackInSlot(index);
        }

        default public int size() {
            return this.itemContainer().getSlots();
        }
    }
}

