/*
 * Decompiled with CFR 0.152.
 */
package liedge.limacore.recipe;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import liedge.limacore.recipe.LimaCustomRecipe;
import liedge.limacore.recipe.LimaRecipeSerializerBuilder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;

public record LimaRecipeSerializer<R extends Recipe<?>>(ResourceLocation id, MapCodec<R> codec, StreamCodec<RegistryFriendlyByteBuf, R> streamCodec) implements RecipeSerializer<R>
{
    public static <R extends Recipe<?>> LimaRecipeSerializer<R> of(ResourceLocation id, MapCodec<R> codec, StreamCodec<RegistryFriendlyByteBuf, R> streamCodec) {
        return new LimaRecipeSerializer<R>(id, codec, streamCodec);
    }

    public static <R extends LimaCustomRecipe<?>> Builder<R> builder(LimaCustomRecipe.RecipeFactory<R> factory) {
        return new Builder<R>(factory);
    }

    public static final class Builder<R extends LimaCustomRecipe<?>>
    extends LimaRecipeSerializerBuilder<R, LimaRecipeSerializer<R>, Builder<R>> {
        private final LimaCustomRecipe.RecipeFactory<R> factory;

        public Builder(LimaCustomRecipe.RecipeFactory<R> factory) {
            this.factory = factory;
        }

        @Override
        public LimaRecipeSerializer<R> build(ResourceLocation id) {
            MapCodec mapCodec = RecordCodecBuilder.mapCodec(instance -> this.commonFields(instance).apply((Applicative)instance, this.factory)).validate(LimaCustomRecipe::checkNotEmpty);
            StreamCodec streamCodec = StreamCodec.composite((StreamCodec)this.itemIngredientStreamCodec, LimaCustomRecipe::getItemIngredients, (StreamCodec)this.fluidIngredientStreamCodec, LimaCustomRecipe::getFluidIngredients, (StreamCodec)this.itemResultStreamCodec, LimaCustomRecipe::getItemResults, (StreamCodec)this.fluidResultStreamCodec, LimaCustomRecipe::getFluidResults, this.factory);
            return LimaRecipeSerializer.of(id, mapCodec, streamCodec);
        }
    }
}

