/*
 * Decompiled with CFR 0.152.
 */
package liedge.limacore.recipe.ingredient;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.stream.Stream;
import liedge.limacore.data.LimaCoreCodecs;
import liedge.limacore.registry.game.LimaCoreIngredientTypes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.neoforge.common.crafting.ICustomIngredient;
import net.neoforged.neoforge.common.crafting.IngredientType;

public record ConsumeChanceIngredient(Ingredient child, float consumeChance) implements ICustomIngredient
{
    public static final MapCodec<ConsumeChanceIngredient> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC_NONEMPTY.fieldOf("child").forGetter(ConsumeChanceIngredient::child), (App)LimaCoreCodecs.floatOpenEndRange(0.0f, 1.0f).fieldOf("consume_chance").forGetter(ConsumeChanceIngredient::consumeChance)).apply((Applicative)instance, ConsumeChanceIngredient::new));

    public static Ingredient of(Ingredient child, float consumeChance) {
        return new Ingredient((ICustomIngredient)new ConsumeChanceIngredient(child, consumeChance));
    }

    public boolean test(ItemStack stack) {
        return this.child.test(stack);
    }

    public Stream<ItemStack> getItems() {
        return Arrays.stream(this.child.getItems());
    }

    public boolean isSimple() {
        return false;
    }

    public IngredientType<?> getType() {
        return (IngredientType)LimaCoreIngredientTypes.CONSUME_CHANCE.get();
    }
}

