/*
 * Decompiled with CFR 0.152.
 */
package liedge.limacore.util;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import liedge.limacore.lib.MobHostility;
import net.minecraft.core.Holder;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.Targeting;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.event.entity.living.LivingKnockBackEvent;
import org.jetbrains.annotations.Nullable;

public final class LimaEntityUtil {
    private LimaEntityUtil() {
    }

    @Nullable
    public static AttributeInstance getAttributeInstanceSafe(@Nullable Entity entity, Holder<Attribute> attribute) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            return livingEntity.getAttribute(attribute);
        }
        return null;
    }

    public static double getAttributeValueSafe(@Nullable Entity entity, Holder<Attribute> attribute) {
        AttributeInstance instance = LimaEntityUtil.getAttributeInstanceSafe(entity, attribute);
        return instance != null ? instance.getValue() : 0.0;
    }

    public static double getAttributeBaseValueSafe(@Nullable Entity entity, Holder<Attribute> attribute) {
        AttributeInstance instance = LimaEntityUtil.getAttributeInstanceSafe(entity, attribute);
        return instance != null ? instance.getBaseValue() : 0.0;
    }

    public static int getEnchantmentLevel(@Nullable Entity entity, Holder<Enchantment> enchantment) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            return EnchantmentHelper.getEnchantmentLevel(enchantment, (LivingEntity)livingEntity);
        }
        return 0;
    }

    public static int getEntityId(@Nullable Entity entity) {
        return entity != null ? entity.getId() : 0;
    }

    public static MobHostility getEntityHostility(Entity target, @Nullable LivingEntity attacker) {
        MobHostility mobHostility;
        Entity entity = target;
        Objects.requireNonNull(entity);
        Entity entity2 = entity;
        int n = 0;
        block6: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{NeutralMob.class, NeutralMob.class, Enemy.class, Targeting.class}, (Object)entity2, n)) {
                case 0: {
                    NeutralMob neutralMob = (NeutralMob)entity2;
                    if (!(target instanceof Enemy)) {
                        n = 1;
                        continue block6;
                    }
                    if (attacker != null && neutralMob.isAngryAt(attacker)) {
                        mobHostility = MobHostility.HOSTILE;
                        break block6;
                    }
                    mobHostility = MobHostility.NEUTRAL_ENEMY;
                    break block6;
                }
                case 1: {
                    NeutralMob neutralMob = (NeutralMob)entity2;
                    if (attacker != null && neutralMob.isAngryAt(attacker)) {
                        mobHostility = MobHostility.HOSTILE;
                        break block6;
                    }
                    mobHostility = MobHostility.NEUTRAL_MOB;
                    break block6;
                }
                case 2: {
                    Enemy enemy = (Enemy)entity2;
                    mobHostility = MobHostility.HOSTILE;
                    break block6;
                }
                case 3: {
                    Targeting targetingEntity = (Targeting)entity2;
                    if (attacker != null && targetingEntity.getTarget() == attacker) {
                        mobHostility = MobHostility.HOSTILE;
                        break block6;
                    }
                    mobHostility = MobHostility.PASSIVE;
                    break block6;
                }
                default: {
                    mobHostility = MobHostility.PASSIVE;
                    break block6;
                }
            }
            break;
        }
        return mobHostility;
    }

    public static void customKnockbackEntity(LivingEntity entity, boolean ignoreResist, double strength, double ratioX, double ratioZ) {
        LivingKnockBackEvent event = CommonHooks.onLivingKnockBack((LivingEntity)entity, (float)((float)strength), (double)ratioX, (double)ratioZ);
        if (event.isCanceled()) {
            return;
        }
        strength = event.getStrength();
        ratioX = event.getRatioX();
        ratioZ = event.getRatioZ();
        double resist = ignoreResist ? 0.0 : entity.getAttributeValue(Attributes.KNOCKBACK_RESISTANCE);
        if ((strength *= 1.0 - resist) > 0.0) {
            entity.hasImpulse = true;
            Vec3 vec3 = entity.getDeltaMovement();
            while (ratioX * ratioX + ratioZ * ratioZ < (double)1.0E-5f) {
                ratioX = (Math.random() - Math.random()) * 0.01;
                ratioZ = (Math.random() - Math.random()) * 0.01;
            }
            Vec3 vec31 = new Vec3(ratioX, 0.0, ratioZ).normalize().scale(strength);
            entity.setDeltaMovement(vec3.x / 2.0 - vec31.x, entity.onGround() ? Math.min(0.4, vec3.y / 2.0 + strength) : vec3.y, vec3.z / 2.0 - vec31.z);
        }
    }

    public static boolean isEntityUsingItem(LivingEntity entity, InteractionHand hand) {
        return entity.isUsingItem() && entity.getUsedItemHand() == hand;
    }
}

