/*
 * Decompiled with CFR 0.152.
 */
package liedge.limacore.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.mojang.logging.LogUtils;
import java.lang.reflect.Type;
import java.util.function.BiConsumer;
import java.util.stream.Collector;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import liedge.limacore.util.LimaRegistryUtil;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import org.slf4j.Logger;

public final class LimaJsonUtil {
    private static final Logger LOGGER = LogUtils.getLogger();

    private LimaJsonUtil() {
    }

    public static Stream<JsonElement> arrayStream(JsonArray array) {
        return StreamSupport.stream(array.spliterator(), false);
    }

    public static Stream<JsonArray> arraysArrayStream(JsonArray array) {
        return LimaJsonUtil.arrayStream(array).map(JsonElement::getAsJsonArray);
    }

    public static Stream<JsonObject> objectsArrayStream(JsonArray array) {
        return LimaJsonUtil.arrayStream(array).map(JsonElement::getAsJsonObject);
    }

    public static Stream<String> stringsArrayStream(JsonArray array) {
        return LimaJsonUtil.arrayStream(array).map(JsonElement::getAsString);
    }

    public static IntStream intArrayStream(JsonArray array) {
        return LimaJsonUtil.arrayStream(array).mapToInt(JsonElement::getAsInt);
    }

    public static DoubleStream doublesArrayStream(JsonArray array) {
        return LimaJsonUtil.arrayStream(array).mapToDouble(JsonElement::getAsDouble);
    }

    public static <T> Stream<T> mapArray(JsonArray array, JsonDeserializationContext ctx, Class<T> typeOfT) {
        return LimaJsonUtil.arrayStream(array).map(e -> ctx.deserialize(e, (Type)typeOfT));
    }

    public static <T extends JsonElement> Collector<T, JsonArray, JsonArray> toJsonArray() {
        return LimaJsonUtil.collectAsArray(JsonArray::add);
    }

    public static Collector<String, JsonArray, JsonArray> toJsonStringArray() {
        return LimaJsonUtil.collectAsArray(JsonArray::add);
    }

    public static Collector<Number, JsonArray, JsonArray> toJsonNumberArray() {
        return LimaJsonUtil.collectAsArray(JsonArray::add);
    }

    private static <T> Collector<T, JsonArray, JsonArray> collectAsArray(BiConsumer<JsonArray, T> accumulator) {
        return Collector.of(JsonArray::new, accumulator, (a1, a2) -> {
            a1.addAll(a2);
            return a1;
        }, new Collector.Characteristics[0]);
    }

    public static ResourceLocation getAsResourceLocation(JsonObject json, String key) {
        return LimaJsonUtil.getAsResourceLocation(json.get(key));
    }

    public static ResourceLocation getAsResourceLocation(JsonElement element) {
        if (!GsonHelper.isStringValue((JsonElement)element)) {
            throw new JsonParseException("Invalid json element type. Excepted string, got: " + GsonHelper.getType((JsonElement)element));
        }
        return ResourceLocation.parse((String)element.getAsString());
    }

    public static <T> ResourceKey<T> getAsResourceKey(ResourceKey<? extends Registry<T>> registryKey, JsonObject json, String key) {
        ResourceLocation location = LimaJsonUtil.getAsResourceLocation(json, key);
        return ResourceKey.create(registryKey, (ResourceLocation)location);
    }

    public static <T> ResourceKey<T> getAsResourceKey(ResourceKey<? extends Registry<T>> registryKey, JsonElement element) {
        ResourceLocation location = LimaJsonUtil.getAsResourceLocation(element);
        return ResourceKey.create(registryKey, (ResourceLocation)location);
    }

    public static JsonElement serializeResourceKey(ResourceKey<?> key) {
        return new JsonPrimitive(key.location().toString());
    }

    public static <T> JsonElement serializeRegistryValue(T value, Registry<T> registry) {
        ResourceLocation key = LimaRegistryUtil.getNonNullRegistryId(value, registry);
        return new JsonPrimitive(key.toString());
    }

    public static <T> T deserializeRegistryValue(JsonElement element, Registry<T> registry) {
        ResourceLocation key = LimaJsonUtil.getAsResourceLocation(element);
        return LimaRegistryUtil.getNonNullRegistryValue(key, registry);
    }
}

