/*
 * Decompiled with CFR 0.152.
 */
package liedge.limacore.util;

import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectSets;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import liedge.limacore.util.LimaCollectionsUtil;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

public final class LimaStreamsUtil {
    private LimaStreamsUtil() {
    }

    public static <T, C extends Collection<T>> BinaryOperator<C> collectionMerger() {
        return LimaCollectionsUtil::mergeCollections;
    }

    public static <T, K, V, M extends Map<K, V>> BiConsumer<M, T> mapAccumulator(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valueMapper) {
        return (map, t) -> LimaCollectionsUtil.putNoDuplicates(map, keyMapper.apply(t), valueMapper.apply(t));
    }

    public static <K, V, M extends Map<K, V>> BinaryOperator<M> mapMerger() {
        return LimaCollectionsUtil::mergeMapsNoDuplicates;
    }

    public static <T> Collector<T, ?, ObjectList<T>> toObjectList() {
        return Collectors.toCollection(ObjectArrayList::new);
    }

    public static <T> Collector<T, ObjectList<T>, ObjectList<T>> toUnmodifiableObjectList() {
        return Collector.of(ObjectArrayList::new, List::add, LimaStreamsUtil.collectionMerger(), ObjectLists::unmodifiable, new Collector.Characteristics[0]);
    }

    public static <T> Collector<T, ?, ObjectSet<T>> toObjectSet() {
        return Collectors.toCollection(ObjectOpenHashSet::new);
    }

    public static <T> Collector<T, ObjectSet<T>, ObjectSet<T>> toUnmodifiableObjectSet() {
        return Collector.of(ObjectOpenHashSet::new, Set::add, LimaStreamsUtil.collectionMerger(), ObjectSets::unmodifiable, new Collector.Characteristics[0]);
    }

    public static <T> Collector<T, ?, NonNullList<T>> toNonNullList() {
        return Collectors.toCollection(NonNullList::create);
    }

    public static <T, K, V, M extends Map<K, V>> Collector<T, ?, M> toMap(Supplier<M> mapSupplier, Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valueMapper) {
        return Collector.of(mapSupplier, LimaStreamsUtil.mapAccumulator(keyMapper, valueMapper), LimaStreamsUtil.mapMerger(), Collector.Characteristics.IDENTITY_FINISH);
    }

    public static <T, K, V, A extends Map<K, V>, R extends Map<K, V>> Collector<T, A, R> toMap(Supplier<A> accumulatorMapSupplier, Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valueMapper, Function<A, R> finisher) {
        return Collector.of(accumulatorMapSupplier, LimaStreamsUtil.mapAccumulator(keyMapper, valueMapper), LimaStreamsUtil.mapMerger(), finisher, new Collector.Characteristics[0]);
    }

    public static <E extends Enum<E>, V> Collector<E, ?, Map<E, V>> toEnumMap(Class<E> enumClass, Function<? super E, ? extends V> valueMapper) {
        return LimaStreamsUtil.toMap(() -> new EnumMap(enumClass), Function.identity(), valueMapper);
    }

    public static <E extends Enum<E>, V> Collector<E, EnumMap<E, V>, Map<E, V>> toUnmodifiableEnumMap(Class<E> enumClass, Function<? super E, ? extends V> valueMapper) {
        return LimaStreamsUtil.toMap(() -> new EnumMap(enumClass), Function.identity(), valueMapper, ImmutableMap::copyOf);
    }

    public static <T, K, U> Collector<T, ?, Object2ObjectMap<K, U>> toObject2ObjectMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper) {
        return LimaStreamsUtil.toMap(Object2ObjectOpenHashMap::new, keyMapper, valueMapper);
    }

    public static <T, K, U> Collector<T, ?, Object2ObjectMap<K, U>> toUnmodifiableObject2ObjectMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper) {
        return LimaStreamsUtil.toMap(Object2ObjectOpenHashMap::new, keyMapper, valueMapper, Object2ObjectMaps::unmodifiable);
    }

    public static Collector<Tag, ?, ListTag> toTagList() {
        return Collectors.toCollection(ListTag::new);
    }

    public static <E extends Enum<E>> Stream<E> enumStream(Class<E> enumClass) {
        return Arrays.stream(LimaCollectionsUtil.checkedEnumConstants(enumClass));
    }
}

