/*
 * Decompiled with CFR 0.152.
 */
package liedge.limacore.util;

import com.ibm.icu.number.LocalizedNumberFormatter;
import com.ibm.icu.number.NumberFormatter;
import com.ibm.icu.number.Precision;
import com.ibm.icu.util.NoUnit;
import com.ibm.icu.util.ULocale;
import java.math.RoundingMode;

public final class LimaTextUtil {
    private static final LocalizedNumberFormatter PERCENT = (LocalizedNumberFormatter)((LocalizedNumberFormatter)NumberFormatter.withLocale((ULocale)ULocale.US).unit(NoUnit.PERCENT)).precision((Precision)Precision.integer());
    private static final LocalizedNumberFormatter PERCENT_1PLACE = (LocalizedNumberFormatter)((LocalizedNumberFormatter)((LocalizedNumberFormatter)NumberFormatter.withLocale((ULocale)ULocale.US).unit(NoUnit.PERCENT)).precision((Precision)Precision.maxFraction((int)1))).roundingMode(RoundingMode.FLOOR);
    private static final LocalizedNumberFormatter WHOLE_NUMBER_COMMA = (LocalizedNumberFormatter)((LocalizedNumberFormatter)NumberFormatter.withLocale((ULocale)ULocale.US).grouping(NumberFormatter.GroupingStrategy.AUTO)).precision((Precision)Precision.integer());
    private static final LocalizedNumberFormatter DECIMAL_2PLACE = (LocalizedNumberFormatter)((LocalizedNumberFormatter)NumberFormatter.withLocale((ULocale)ULocale.US).precision((Precision)Precision.maxFraction((int)2))).roundingMode(RoundingMode.FLOOR);

    private LimaTextUtil() {
    }

    public static String formatPercentage(double value) {
        return PERCENT.format(value * 100.0).toString();
    }

    public static String format1PlacePercentage(double value) {
        return PERCENT_1PLACE.format(value * 100.0).toString();
    }

    public static String formatWholeNumber(int value) {
        return WHOLE_NUMBER_COMMA.format((long)value).toString();
    }

    public static String formatWholeNumber(double value) {
        return WHOLE_NUMBER_COMMA.format(value).toString();
    }

    public static String format2PlaceDecimal(double value) {
        return DECIMAL_2PLACE.format(value).toString();
    }
}

