/*
 * Decompiled with CFR 0.152.
 */
package liedge.limacore.world.loot;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemKilledByPlayerCondition;
import net.neoforged.neoforge.common.loot.AddTableLootModifier;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;

public abstract class LootModifierBuilder<M extends IGlobalLootModifier, B extends LootModifierBuilder<M, B>> {
    private final List<LootItemCondition> conditions = new ObjectArrayList();

    public static SimpleBuilder<AddTableLootModifier> rollLootTable(ResourceKey<LootTable> lootTableKey) {
        return new SimpleBuilder<AddTableLootModifier>(conditions -> new AddTableLootModifier(conditions, lootTableKey));
    }

    protected final B selfUnchecked() {
        return (B)this;
    }

    protected LootItemCondition[] buildConditions() {
        return (LootItemCondition[])this.conditions.toArray(LootItemCondition[]::new);
    }

    protected abstract M createModifier(LootItemCondition[] var1);

    public final M build() {
        return this.createModifier((LootItemCondition[])this.conditions.toArray(LootItemCondition[]::new));
    }

    public B requires(LootItemCondition condition) {
        this.conditions.add(condition);
        return this.selfUnchecked();
    }

    public B requires(LootItemCondition.Builder builder) {
        return this.requires(builder.build());
    }

    public B killedByPlayer() {
        return this.requires(LootItemKilledByPlayerCondition.killedByPlayer());
    }

    public static class SimpleBuilder<M extends IGlobalLootModifier>
    extends LootModifierBuilder<M, SimpleBuilder<M>> {
        private final Function<LootItemCondition[], M> factory;

        public SimpleBuilder(Function<LootItemCondition[], M> factory) {
            this.factory = factory;
        }

        @Override
        protected M createModifier(LootItemCondition[] conditions) {
            return (M)((IGlobalLootModifier)this.factory.apply(conditions));
        }
    }
}

