/*
 * Decompiled with CFR 0.152.
 */
package liedge.limacore.world.loot;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Set;
import liedge.limacore.registry.game.LimaCoreLootRegistries;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public final class SaveBlockEntityFunction
extends LootItemConditionalFunction {
    public static final MapCodec<SaveBlockEntityFunction> CODEC = RecordCodecBuilder.mapCodec(instance -> SaveBlockEntityFunction.commonFields((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, SaveBlockEntityFunction::new));

    public static LootItemConditionalFunction.Builder<?> saveBlockEntityData() {
        return SaveBlockEntityFunction.simpleBuilder(SaveBlockEntityFunction::new);
    }

    private SaveBlockEntityFunction(List<LootItemCondition> conditions) {
        super(conditions);
    }

    public LootItemFunctionType<? extends LootItemConditionalFunction> getType() {
        return (LootItemFunctionType)LimaCoreLootRegistries.SAVE_BLOCK_ENTITY.get();
    }

    protected ItemStack run(ItemStack stack, LootContext context) {
        BlockEntity blockEntity = (BlockEntity)context.getParamOrNull(LootContextParams.BLOCK_ENTITY);
        Item item = stack.getItem();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            if (blockEntity != null && blockEntity.getType().getValidBlocks().contains(blockItem.getBlock())) {
                blockEntity.saveToItem(stack, (HolderLookup.Provider)context.getLevel().registryAccess());
            }
        }
        return stack;
    }

    public Set<LootContextParam<?>> getReferencedContextParams() {
        return Set.of(LootContextParams.BLOCK_ENTITY);
    }
}

