/*
 * Decompiled with CFR 0.152.
 */
package liedge.limacore.world.loot.condition;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import liedge.limacore.lib.MobHostility;
import liedge.limacore.registry.game.LimaCoreLootRegistries;
import liedge.limacore.util.LimaCoreUtil;
import liedge.limacore.util.LimaEntityUtil;
import liedge.limacore.world.loot.condition.EntityComparisonLootCondition;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;

public final class EntityHostilityLootCondition
extends EntityComparisonLootCondition {
    public static final MapCodec<EntityHostilityLootCondition> CODEC = RecordCodecBuilder.mapCodec(instance -> EntityHostilityLootCondition.commonFields(instance).and((App)MobHostility.CODEC.optionalFieldOf("min", (Object)MobHostility.PASSIVE).forGetter(o -> o.min)).and((App)MobHostility.CODEC.optionalFieldOf("max", (Object)MobHostility.HOSTILE).forGetter(o -> o.max)).apply((Applicative)instance, EntityHostilityLootCondition::new)).validate(EntityHostilityLootCondition::validate);
    private final MobHostility min;
    private final MobHostility max;

    private static DataResult<EntityHostilityLootCondition> validate(EntityHostilityLootCondition value) {
        if (value.max.atLeast(value.min)) {
            return DataResult.success((Object)value);
        }
        return DataResult.error(() -> "Minimum hostility is higher than maximum.");
    }

    public static LootItemCondition.Builder between(MobHostility min, MobHostility max) {
        return () -> new EntityHostilityLootCondition(LootContext.EntityTarget.THIS, LootContext.EntityTarget.ATTACKER, min, max);
    }

    public static LootItemCondition.Builder atLeast(MobHostility min) {
        return EntityHostilityLootCondition.between(min, MobHostility.HOSTILE);
    }

    public static LootItemCondition.Builder atMost(MobHostility max) {
        return EntityHostilityLootCondition.between(MobHostility.PASSIVE, max);
    }

    public EntityHostilityLootCondition(LootContext.EntityTarget attacker, LootContext.EntityTarget targeted, MobHostility min, MobHostility max) {
        super(attacker, targeted);
        this.min = min;
        this.max = max;
    }

    @Override
    protected boolean testEntities(Entity firstEntity, Entity secondEntity) {
        LivingEntity livingSecond = LimaCoreUtil.castOrNull(LivingEntity.class, secondEntity);
        return LimaEntityUtil.getEntityHostility(firstEntity, livingSecond).between(this.min, this.max);
    }

    public LootItemConditionType getType() {
        return (LootItemConditionType)LimaCoreLootRegistries.HOSTILITY_CONDITION.get();
    }
}

