/*
 * Decompiled with CFR 0.152.
 */
package liedge.limacore.world.loot.level;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.floats.FloatList;
import java.util.List;
import java.util.Optional;
import liedge.limacore.registry.game.LimaCoreLootRegistries;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import org.jetbrains.annotations.Nullable;

public record RangedLookupLevelBasedValue(List<Float> values, int levelOffset, Optional<Float> defaultBelow, Optional<Float> defaultAbove) implements LevelBasedValue
{
    public static final MapCodec<RangedLookupLevelBasedValue> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ExtraCodecs.nonEmptyList((Codec)Codec.FLOAT.listOf()).fieldOf("values").forGetter(RangedLookupLevelBasedValue::values), (App)ExtraCodecs.NON_NEGATIVE_INT.optionalFieldOf("level_offset", (Object)0).forGetter(RangedLookupLevelBasedValue::levelOffset), (App)Codec.FLOAT.optionalFieldOf("default_below").forGetter(RangedLookupLevelBasedValue::defaultBelow), (App)Codec.FLOAT.optionalFieldOf("default_above").forGetter(RangedLookupLevelBasedValue::defaultAbove)).apply((Applicative)instance, RangedLookupLevelBasedValue::new));

    public static RangedLookupLevelBasedValue create(int startingLevel, @Nullable Float defaultBelow, @Nullable Float defaultAbove, List<Float> values) {
        Preconditions.checkArgument((startingLevel > 0 ? 1 : 0) != 0, (Object)"Ranged lookup table level range must start at 1.");
        return new RangedLookupLevelBasedValue(values, startingLevel - 1, Optional.ofNullable(defaultBelow), Optional.ofNullable(defaultAbove));
    }

    public static RangedLookupLevelBasedValue create(int startingLevel, @Nullable Float defaultBelow, @Nullable Float defaultAbove, float ... values) {
        return RangedLookupLevelBasedValue.create(startingLevel, defaultBelow, defaultAbove, (List<Float>)FloatList.of((float[])values));
    }

    public static RangedLookupLevelBasedValue lookupAfterLevel(int startingLevel, float ... values) {
        return RangedLookupLevelBasedValue.create(startingLevel, null, null, values);
    }

    public static RangedLookupLevelBasedValue lookupAfterLevelOrBelow(int startingLevel, float defaultBelow, float ... values) {
        return RangedLookupLevelBasedValue.create(startingLevel, Float.valueOf(defaultBelow), null, values);
    }

    public static RangedLookupLevelBasedValue lookupAfterLevelOrAbove(int startingLevel, float defaultAbove, float ... values) {
        return RangedLookupLevelBasedValue.create(startingLevel, null, Float.valueOf(defaultAbove), values);
    }

    public static RangedLookupLevelBasedValue linearLookup(float ... values) {
        return RangedLookupLevelBasedValue.lookupAfterLevel(1, values);
    }

    public float calculate(int level) {
        int shiftedLevel = level - 1 - this.levelOffset;
        if (shiftedLevel < 0) {
            return this.defaultBelow.orElse(this.values.getFirst()).floatValue();
        }
        if (shiftedLevel >= this.values.size()) {
            return this.defaultAbove.orElse(this.values.getLast()).floatValue();
        }
        return this.values.get(shiftedLevel).floatValue();
    }

    public MapCodec<? extends LevelBasedValue> codec() {
        return (MapCodec)LimaCoreLootRegistries.RANGED_LOOKUP_LEVEL_BASED_VALUE.get();
    }
}

