/*
 * Decompiled with CFR 0.152.
 */
package liedge.limacore.world.loot.number;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import liedge.limacore.registry.game.LimaCoreLootRegistries;
import liedge.limacore.util.LimaEntityUtil;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.providers.number.LootNumberProviderType;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public record EntityAttributeValueProvider(LootContext.EntityTarget target, Holder<Attribute> attribute, boolean base) implements NumberProvider
{
    public static final MapCodec<EntityAttributeValueProvider> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)LootContext.EntityTarget.CODEC.fieldOf("target").forGetter(EntityAttributeValueProvider::target), (App)Attribute.CODEC.fieldOf("attribute").forGetter(EntityAttributeValueProvider::attribute), (App)Codec.BOOL.optionalFieldOf("base", (Object)false).forGetter(EntityAttributeValueProvider::base)).apply((Applicative)instance, EntityAttributeValueProvider::new));

    public static NumberProvider totalValue(LootContext.EntityTarget target, Holder<Attribute> attribute) {
        return new EntityAttributeValueProvider(target, attribute, false);
    }

    public static NumberProvider baseValue(LootContext.EntityTarget target, Holder<Attribute> attribute) {
        return new EntityAttributeValueProvider(target, attribute, true);
    }

    public float getFloat(LootContext ctx) {
        Entity entity = (Entity)ctx.getParamOrNull(this.target.getParam());
        double value = this.base ? LimaEntityUtil.getAttributeBaseValueSafe(entity, this.attribute) : LimaEntityUtil.getAttributeValueSafe(entity, this.attribute);
        return (float)value;
    }

    public LootNumberProviderType getType() {
        return (LootNumberProviderType)LimaCoreLootRegistries.ENTITY_ATTRIBUTE_VALUE_PROVIDER.get();
    }

    public Set<LootContextParam<?>> getReferencedContextParams() {
        return Set.of(this.target.getParam());
    }
}

