/*
 * Decompiled with CFR 0.152.
 */
package liedge.limacore.world.loot.number;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import liedge.limacore.registry.game.LimaCoreLootRegistries;
import liedge.limacore.util.LimaEntityUtil;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.providers.number.LootNumberProviderType;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public record EntityEnchantmentLevelProvider(LootContext.EntityTarget target, Holder<Enchantment> enchantment) implements NumberProvider
{
    public static final MapCodec<EntityEnchantmentLevelProvider> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)LootContext.EntityTarget.CODEC.fieldOf("target").forGetter(EntityEnchantmentLevelProvider::target), (App)Enchantment.CODEC.fieldOf("enchantment").forGetter(EntityEnchantmentLevelProvider::enchantment)).apply((Applicative)instance, EntityEnchantmentLevelProvider::new));

    public static EntityEnchantmentLevelProvider enchantLevel(LootContext.EntityTarget target, Holder<Enchantment> enchantment) {
        return new EntityEnchantmentLevelProvider(target, enchantment);
    }

    public float getFloat(LootContext context) {
        return LimaEntityUtil.getEnchantmentLevel((Entity)context.getParamOrNull(this.target.getParam()), this.enchantment);
    }

    public LootNumberProviderType getType() {
        return (LootNumberProviderType)LimaCoreLootRegistries.ENTITY_ENCHANTMENT_LEVEL_PROVIDER.get();
    }

    public Set<LootContextParam<?>> getReferencedContextParams() {
        return Set.of(this.target.getParam());
    }
}

