/*
 * Decompiled with CFR 0.152.
 */
package liedge.limacore.world.loot.number;

import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import liedge.limacore.lib.math.LimaCoreMath;
import liedge.limacore.lib.math.LimaRoundingMode;
import liedge.limacore.lib.math.MathOperation;
import liedge.limacore.registry.game.LimaCoreLootRegistries;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.providers.number.LootNumberProviderType;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;

public record MathOpsNumberProvider(NumberProvider first, NumberProvider second, MathOperation operation, LimaRoundingMode roundingMode) implements NumberProvider
{
    public static final MapCodec<MathOpsNumberProvider> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)NumberProviders.CODEC.fieldOf("first").forGetter(MathOpsNumberProvider::first), (App)NumberProviders.CODEC.fieldOf("second").forGetter(MathOpsNumberProvider::second), (App)MathOperation.SINGLE_OP_CODEC.fieldOf("op").forGetter(MathOpsNumberProvider::operation), (App)LimaRoundingMode.CODEC.optionalFieldOf("rounding_mode", (Object)LimaRoundingMode.NATURAL).forGetter(MathOpsNumberProvider::roundingMode)).apply((Applicative)instance, MathOpsNumberProvider::new));

    public static NumberProvider of(NumberProvider first, NumberProvider second, MathOperation operation) {
        return new MathOpsNumberProvider(first, second, operation, LimaRoundingMode.NATURAL);
    }

    public float getFloat(LootContext context) {
        return (float)this.getDouble(context);
    }

    public int getInt(LootContext context) {
        return LimaCoreMath.round(this.getDouble(context), this.roundingMode);
    }

    private double getDouble(LootContext context) {
        return this.operation.applyAsDouble(this.first.getFloat(context), this.second.getFloat(context));
    }

    public LootNumberProviderType getType() {
        return (LootNumberProviderType)LimaCoreLootRegistries.MATH_OPS_NUMBER_PROVIDER.get();
    }

    public Set<LootContextParam<?>> getReferencedContextParams() {
        return Sets.union((Set)this.first.getReferencedContextParams(), (Set)this.second.getReferencedContextParams());
    }
}

