/*
 * Decompiled with CFR 0.152.
 */
package liedge.limacore.block;

import liedge.limacore.blockentity.LimaBlockEntity;
import liedge.limacore.blockentity.LimaBlockEntityType;
import liedge.limacore.menu.LimaMenuProvider;
import liedge.limacore.util.LimaBlockUtil;
import liedge.limacore.util.LimaCoreUtil;
import liedge.limacore.util.LimaRegistryUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;

public abstract class LimaEntityBlock
extends Block
implements EntityBlock {
    private LimaBlockEntityType<?> blockEntityType;

    protected LimaEntityBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        LimaBlockEntityType<?> type = this.getBlockEntityType(state);
        return type != null ? type.create(pos, state) : null;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> otherType) {
        if (this.getBlockEntityType(state) == otherType) {
            if (level.isClientSide() && this.shouldTickClient(state)) {
                return LimaBlockEntity.createClientTicker();
            }
            if (!level.isClientSide() && this.shouldTickServer(state)) {
                return LimaBlockEntity.createServerTicker();
            }
        }
        return null;
    }

    @Nullable
    public LimaMenuProvider getMenuProvider(BlockState state, Level level, BlockPos pos) {
        return this.blockEntityMenuProvider(level, pos);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        return this.tryOpenMenu(state, level, pos, player);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        LimaBlockEntity blockEntity;
        ItemStack stack = super.getCloneItemStack(state, target, level, pos, player);
        LimaBlockEntityType<?> type = this.getBlockEntityType(state);
        if (type != null && (blockEntity = (LimaBlockEntity)type.getBlockEntity((BlockGetter)level, pos)) != null) {
            blockEntity.saveToItem(stack, (HolderLookup.Provider)level.registryAccess());
        }
        return stack;
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        if (placer instanceof Player) {
            Player player = (Player)placer;
            LimaBlockEntity blockEntity = LimaBlockUtil.getSafeBlockEntity((LevelReader)level, pos, LimaBlockEntity.class);
            if (blockEntity != null) {
                blockEntity.onPlacedByPlayer(level, player, stack);
            }
        }
    }

    public void onBlockStateChange(LevelReader level, BlockPos pos, BlockState oldState, BlockState newState) {
        LimaBlockEntity blockEntity;
        if (oldState.getBlock() == newState.getBlock() && newState.getBlock() == this && (blockEntity = LimaBlockUtil.getSafeBlockEntity(level, pos, LimaBlockEntity.class)) != null) {
            blockEntity.onBlockStateUpdated(pos, oldState, newState);
        }
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        if (state.hasBlockEntity() && !state.is(newState.getBlock())) {
            LimaBlockEntity blockEntity = LimaBlockUtil.getSafeBlockEntity((LevelReader)level, pos, LimaBlockEntity.class);
            if (blockEntity != null) {
                blockEntity.onRemovedFromLevel(level, pos, state, newState);
            }
            level.removeBlockEntity(pos);
        }
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public LimaBlockEntityType<?> getBlockEntityType(BlockState state) {
        if (this.blockEntityType == null) {
            ResourceLocation id = LimaRegistryUtil.getBlockId(this);
            this.blockEntityType = LimaCoreUtil.castOrThrow(LimaBlockEntityType.class, LimaRegistryUtil.getNonNullRegistryValue(id, BuiltInRegistries.BLOCK_ENTITY_TYPE), () -> new IllegalStateException("No valid block entity type matches block id '" + String.valueOf(id) + "'"));
        }
        return this.blockEntityType;
    }

    @Nullable
    protected LimaMenuProvider blockEntityMenuProvider(Level level, BlockPos pos) {
        LimaBlockEntity blockEntity = LimaBlockUtil.getSafeBlockEntity((LevelReader)level, pos, LimaBlockEntity.class);
        return blockEntity != null ? blockEntity.getType().createMenuProvider(blockEntity) : null;
    }

    protected InteractionResult tryOpenMenu(BlockState state, Level level, BlockPos pos, Player player) {
        LimaMenuProvider provider;
        if (level.isClientSide()) {
            return InteractionResult.SUCCESS;
        }
        if (!player.isCrouching() && (provider = this.getMenuProvider(state, level, pos)) != null) {
            provider.openMenuScreen(player);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    protected boolean shouldTickClient(BlockState state) {
        return false;
    }

    protected boolean shouldTickServer(BlockState state) {
        return false;
    }
}

