/*
 * Decompiled with CFR 0.152.
 */
package liedge.limacore.blockentity;

import java.util.List;
import java.util.Objects;
import liedge.limacore.blockentity.LimaBlockEntityAccess;
import liedge.limacore.blockentity.LimaBlockEntityType;
import liedge.limacore.blockentity.OwnableBlockEntity;
import liedge.limacore.lib.Translatable;
import liedge.limacore.menu.BlockEntityMenuType;
import liedge.limacore.network.IndexedStreamData;
import liedge.limacore.network.packet.ClientboundBlockEntityDataWatcherPacket;
import liedge.limacore.network.packet.ServerboundBlockEntityDataRequestPacket;
import liedge.limacore.network.sync.DataWatcherHolder;
import liedge.limacore.network.sync.LimaDataWatcher;
import liedge.limacore.util.LimaCoreUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public abstract class LimaBlockEntity
extends BlockEntity
implements DataWatcherHolder,
LimaBlockEntityAccess {
    private final List<LimaDataWatcher<?>> dataWatchers = this.createDataWatchers();

    protected LimaBlockEntity(LimaBlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public boolean canPlayerUse(Player player) {
        if (this.level == null || this.level.getBlockEntity(this.worldPosition) != this) {
            return false;
        }
        return player.distanceToSqr((double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5) <= 64.0;
    }

    public Component getMenuTitle(BlockEntityMenuType<?, ?> menuType) {
        Translatable defaultTitle = menuType.getDefaultTitle();
        return defaultTitle != null ? defaultTitle.translate() : this.getBlockState().getBlock().getName();
    }

    @Override
    public final LimaBlockEntity getAsLimaBlockEntity() {
        return this;
    }

    @Override
    public final List<LimaDataWatcher<?>> getDataWatchers() {
        return this.dataWatchers;
    }

    @Override
    public void sendDataWatcherPacket(List<IndexedStreamData<?>> streamData) {
        ServerLevel level = this.nonNullServerLevel();
        BlockPos blockPos = this.getBlockPos();
        PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)level, (ChunkPos)level.getChunkAt(blockPos).getPos(), (CustomPacketPayload)new ClientboundBlockEntityDataWatcherPacket(streamData, blockPos), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        CompoundTag updateTag = this.getUpdateTag((HolderLookup.Provider)this.nonNullLevel().registryAccess());
        if (!updateTag.isEmpty()) {
            return ClientboundBlockEntityDataPacket.create((BlockEntity)this, ($1, $2) -> updateTag);
        }
        return null;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider lookupProvider) {
        this.handleUpdateTag(pkt.getTag(), lookupProvider);
    }

    public LimaBlockEntityType<?> getType() {
        return (LimaBlockEntityType)super.getType();
    }

    public void onLoad() {
        super.onLoad();
        if (this.level != null) {
            if (this.level.isClientSide) {
                PacketDistributor.sendToServer((CustomPacketPayload)new ServerboundBlockEntityDataRequestPacket(this.getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                this.onLoadClient(this.level);
            } else {
                this.onLoadServer(LimaCoreUtil.castOrThrow(ServerLevel.class, this.level));
            }
        }
    }

    protected void onLoadClient(Level level) {
    }

    protected void onLoadServer(ServerLevel level) {
    }

    public void removeComponentsFromTag(CompoundTag tag) {
    }

    protected <T> BlockCapabilityCache<T, Direction> createCapabilityCache(BlockCapability<T, Direction> capability, ServerLevel level, Direction side, Runnable invalidationListener) {
        BlockPos neighborPos = this.getBlockPos().relative(side);
        return BlockCapabilityCache.create(capability, (ServerLevel)level, (BlockPos)neighborPos, (Object)side.getOpposite(), () -> !this.isRemoved(), (Runnable)invalidationListener);
    }

    protected <T> BlockCapabilityCache<T, Direction> createCapabilityCache(BlockCapability<T, Direction> capability, ServerLevel level, Direction side) {
        return this.createCapabilityCache(capability, level, side, () -> {});
    }

    public void onPlacedByPlayer(Level level, Player player, ItemStack blockItem) {
        LimaBlockEntity limaBlockEntity = this;
        if (limaBlockEntity instanceof OwnableBlockEntity) {
            OwnableBlockEntity ownable = (OwnableBlockEntity)((Object)limaBlockEntity);
            ownable.setOwner(player);
        }
    }

    public void onRemovedFromLevel(Level level, BlockPos pos, BlockState oldState, BlockState newState) {
    }

    public void onBlockStateUpdated(BlockPos pos, BlockState oldState, BlockState newState) {
    }

    @Override
    public final Level nonNullLevel() {
        return Objects.requireNonNull(this.level, () -> String.format("Attempted to access level for block entity at %s before it has been assigned.", this.worldPosition.toShortString()));
    }

    @Override
    public final ServerLevel nonNullServerLevel() {
        return LimaCoreUtil.castOrThrow(ServerLevel.class, (Object)this.level, () -> new IllegalStateException(String.format("Attempted to access server level for block entity at %s on the client or before it has been assigned.", this.worldPosition.toShortString())));
    }

    public boolean checkServerSide() {
        return this.level != null && !this.level.isClientSide();
    }

    public boolean checkClientSide() {
        return this.level != null && this.level.isClientSide();
    }

    protected void tickServer(ServerLevel level, BlockPos pos, BlockState state) {
    }

    protected void tickClient(Level level, BlockPos pos, BlockState state) {
    }

    public static BlockEntityTicker<LimaBlockEntity> createServerTicker() {
        return (level, pos, state, be) -> {
            be.tickServer((ServerLevel)level, pos, state);
            be.tickDataWatchers();
        };
    }

    public static BlockEntityTicker<LimaBlockEntity> createClientTicker() {
        return (level, pos, state, be) -> be.tickClient(level, pos, state);
    }
}

