/*
 * Decompiled with CFR 0.152.
 */
package liedge.limacore.blockentity;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectSets;
import java.util.Objects;
import java.util.Set;
import liedge.limacore.blockentity.LimaBlockEntity;
import liedge.limacore.menu.BlockEntityMenuProvider;
import liedge.limacore.menu.BlockEntityMenuType;
import liedge.limacore.menu.LimaMenuProvider;
import net.minecraft.core.Holder;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.neoforge.registries.datamaps.DataMapType;
import org.jetbrains.annotations.Nullable;

public class LimaBlockEntityType<BE extends LimaBlockEntity>
extends BlockEntityType<BE> {
    @Nullable
    private final Holder<MenuType<?>> menuTypeHolder;

    public static <BE extends LimaBlockEntity> LimaBlockEntityType<BE> of(BlockEntityType.BlockEntitySupplier<BE> factory, Holder<Block> holder) {
        return new LimaBlockEntityType<BE>(factory, Set.of((Block)holder.value()), null);
    }

    public static <BE extends LimaBlockEntity> LimaBlockEntityType<BE> of(BlockEntityType.BlockEntitySupplier<BE> factory, Holder<Block> holder, Holder<MenuType<?>> menuTypeHolder) {
        return new LimaBlockEntityType<BE>(factory, Set.of((Block)holder.value()), menuTypeHolder);
    }

    public static <BE extends LimaBlockEntity> Builder<BE> builder(BlockEntityType.BlockEntitySupplier<BE> factory) {
        return new Builder<BE>(factory);
    }

    protected LimaBlockEntityType(BlockEntityType.BlockEntitySupplier<BE> factory, Set<Block> validBlocks, @Nullable Holder<MenuType<?>> menuTypeHolder) {
        super(factory, validBlocks, null);
        this.menuTypeHolder = menuTypeHolder;
    }

    @Nullable
    public <T> T getDataMap(DataMapType<BlockEntityType<?>, T> dataMapType) {
        return (T)Objects.requireNonNull(this.builtInRegistryHolder()).getData(dataMapType);
    }

    public <T> T getDataMapOrDefault(DataMapType<BlockEntityType<?>, T> dataMapType, T fallback) {
        return Objects.requireNonNullElse(this.getDataMap(dataMapType), fallback);
    }

    @Nullable
    public LimaMenuProvider createMenuProvider(LimaBlockEntity blockEntity, boolean closeClientContainer) {
        Object object;
        if (this.menuTypeHolder != null && (object = this.menuTypeHolder.value()) instanceof BlockEntityMenuType) {
            BlockEntityMenuType menuType = (BlockEntityMenuType)((Object)object);
            return new BlockEntityMenuProvider(menuType, blockEntity, closeClientContainer);
        }
        return null;
    }

    @Nullable
    public LimaMenuProvider createMenuProvider(LimaBlockEntity blockEntity) {
        return this.createMenuProvider(blockEntity, true);
    }

    public static class Builder<BE extends LimaBlockEntity>
    extends AbstractBuilder<BE, LimaBlockEntityType<BE>, Builder<BE>> {
        private Builder(BlockEntityType.BlockEntitySupplier<BE> factory) {
            super(factory);
        }

        @Override
        public LimaBlockEntityType<BE> build() {
            return new LimaBlockEntityType(this.factory, this.getValidBlocks(), this.menuTypeHolder);
        }
    }

    public static abstract class AbstractBuilder<BE extends LimaBlockEntity, TYPE extends LimaBlockEntityType<BE>, B extends AbstractBuilder<BE, TYPE, B>> {
        protected final BlockEntityType.BlockEntitySupplier<BE> factory;
        private final ObjectSet<Block> validBlocks = new ObjectOpenHashSet();
        @Nullable
        protected Holder<MenuType<?>> menuTypeHolder;

        protected AbstractBuilder(BlockEntityType.BlockEntitySupplier<BE> factory) {
            this.factory = factory;
        }

        public B withBlock(Block block) {
            this.validBlocks.add((Object)block);
            return this.thisBuilder();
        }

        public B withBlock(Holder<Block> holder) {
            return this.withBlock((Block)holder.value());
        }

        public B hasMenu(Holder<MenuType<?>> menuTypeHolder) {
            this.menuTypeHolder = menuTypeHolder;
            return this.thisBuilder();
        }

        public abstract TYPE build();

        protected B thisBuilder() {
            return (B)this;
        }

        protected Set<Block> getValidBlocks() {
            Preconditions.checkState((!this.validBlocks.isEmpty() ? 1 : 0) != 0, (Object)"Valid blocks cannot be empty.");
            return ObjectSets.unmodifiable(this.validBlocks);
        }
    }
}

