/*
 * Decompiled with CFR 0.152.
 */
package liedge.limacore.blockentity;

import java.util.UUID;
import liedge.limacore.blockentity.LimaBlockEntityAccess;
import liedge.limacore.util.LimaNbtUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public interface OwnableBlockEntity
extends LimaBlockEntityAccess {
    @Nullable
    public UUID getOwnerUUID();

    public void setOwnerUUID(@Nullable UUID var1);

    @Nullable
    default public Player getOwner() {
        UUID uuid = this.getOwnerUUID();
        return uuid != null ? this.nonNullLevel().getPlayerByUUID(uuid) : null;
    }

    default public void setOwner(@Nullable Player player) {
        UUID uuid = player != null ? player.getUUID() : null;
        this.setOwnerUUID(uuid);
    }

    default public void saveOwnerID(CompoundTag tag) {
        LimaNbtUtil.putOptionalUUID(tag, "owner", this.getOwnerUUID());
    }

    default public void loadOwnerID(CompoundTag tag) {
        this.setOwnerUUID(LimaNbtUtil.getOptionalUUID(tag, "owner"));
    }
}

