/*
 * Decompiled with CFR 0.152.
 */
package liedge.limacore.capability.energy;

import liedge.limacore.capability.energy.EnergyHolderBlockEntity;
import liedge.limacore.capability.energy.LimaEnergyStorage;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.IntTag;
import net.neoforged.neoforge.common.util.INBTSerializable;

public class LimaBlockEntityEnergyStorage
extends LimaEnergyStorage
implements INBTSerializable<IntTag> {
    private final EnergyHolderBlockEntity energyHolder;
    private int energy;

    public LimaBlockEntityEnergyStorage(EnergyHolderBlockEntity energyHolder, int maxEnergy, int transferRate) {
        super(maxEnergy, transferRate);
        this.energyHolder = energyHolder;
    }

    public LimaBlockEntityEnergyStorage(EnergyHolderBlockEntity energyHolder) {
        this(energyHolder, energyHolder.getBaseEnergyCapacity(), energyHolder.getBaseEnergyTransferRate());
    }

    @Override
    public void setEnergyStored(int energy) {
        int oldEnergy = this.energy;
        this.energy = Math.max(energy, 0);
        this.energyHolder.onEnergyChanged(oldEnergy);
    }

    @Override
    public int getEnergyStored() {
        return this.energy;
    }

    public IntTag serializeNBT(HolderLookup.Provider provider) {
        return IntTag.valueOf((int)this.energy);
    }

    public void deserializeNBT(HolderLookup.Provider provider, IntTag nbt) {
        this.energy = nbt.getAsInt();
    }
}

