/*
 * Decompiled with CFR 0.152.
 */
package liedge.limacore.capability.energy;

import liedge.limacore.capability.energy.LimaEnergyStorage;
import liedge.limacore.lib.math.LimaCoreMath;
import liedge.limacore.util.LimaTextUtil;
import net.minecraft.util.Mth;
import net.neoforged.neoforge.energy.IEnergyStorage;

public final class LimaEnergyUtil {
    private LimaEnergyUtil() {
    }

    public static int transferEnergyBetween(IEnergyStorage source, IEnergyStorage destination, int maxTransfer, boolean simulate) {
        int extracted = source.extractEnergy(maxTransfer, true);
        int accepted = destination.receiveEnergy(extracted, true);
        if (simulate) {
            return accepted;
        }
        accepted = source.extractEnergy(accepted, false);
        return destination.receiveEnergy(accepted, false);
    }

    public static float getFillPercentage(IEnergyStorage storage) {
        return LimaCoreMath.divideFloat(storage.getEnergyStored(), storage.getMaxEnergyStored());
    }

    public static float getClampedFillPercentage(IEnergyStorage storage) {
        return Mth.clamp((float)LimaEnergyUtil.getFillPercentage(storage), (float)0.0f, (float)1.0f);
    }

    public static String toEnergyString(int energy) {
        if (energy >= 1000000000) {
            return LimaTextUtil.format2PlaceDecimal((double)energy / 1.0E9) + " GCE";
        }
        if (energy >= 1000000) {
            return LimaTextUtil.format2PlaceDecimal((double)energy / 1000000.0) + " MCE";
        }
        if (energy >= 10000) {
            return LimaTextUtil.format2PlaceDecimal((double)energy / 1000.0) + " kCE";
        }
        return energy + " CE";
    }

    public static String toEnergyPerTickString(int energy) {
        return LimaEnergyUtil.toEnergyString(energy) + "/t";
    }

    public static String toEnergyStoredString(int energy, int capacity) {
        return LimaEnergyUtil.toEnergyString(energy) + "/" + LimaEnergyUtil.toEnergyString(capacity);
    }

    public static String toEnergyStoredString(IEnergyStorage storage) {
        return LimaEnergyUtil.toEnergyStoredString(storage.getEnergyStored(), storage.getMaxEnergyStored());
    }

    public static int receiveWithoutLimit(IEnergyStorage storage, int toReceive, boolean simulate) {
        int limit;
        int totalReceived;
        int received;
        for (totalReceived = 0; totalReceived < toReceive && (received = storage.receiveEnergy(limit = toReceive - totalReceived, simulate)) > 0; totalReceived += received) {
        }
        return totalReceived;
    }

    public static int extractWithoutLimit(IEnergyStorage storage, int toExtract, boolean simulate) {
        int limit;
        int totalExtracted;
        int extracted;
        for (totalExtracted = 0; totalExtracted < toExtract && (extracted = storage.extractEnergy(limit = toExtract - totalExtracted, simulate)) > 0; totalExtracted += extracted) {
        }
        return totalExtracted;
    }

    public static boolean consumeEnergy(IEnergyStorage storage, int toExtract, boolean ignoreLimit) {
        if (storage instanceof LimaEnergyStorage) {
            return LimaEnergyUtil.consumeFromLimaSource((LimaEnergyStorage)storage, toExtract, ignoreLimit);
        }
        return LimaEnergyUtil.consumeFromGeneralSource(storage, toExtract, ignoreLimit);
    }

    private static boolean consumeFromLimaSource(LimaEnergyStorage storage, int toExtract, boolean ignoreLimit) {
        if (storage.extractEnergy(toExtract, true, ignoreLimit) == toExtract) {
            storage.extractEnergy(toExtract, false, ignoreLimit);
            return true;
        }
        return false;
    }

    private static boolean consumeFromGeneralSource(IEnergyStorage storage, int toExtract, boolean ignoreLimit) {
        if (!ignoreLimit && storage.extractEnergy(toExtract, true) == toExtract) {
            storage.extractEnergy(toExtract, false);
            return true;
        }
        if (ignoreLimit && LimaEnergyUtil.extractWithoutLimit(storage, toExtract, true) == toExtract) {
            LimaEnergyUtil.extractWithoutLimit(storage, toExtract, false);
            return true;
        }
        return false;
    }
}

