/*
 * Decompiled with CFR 0.152.
 */
package liedge.limacore.capability.fluid;

import liedge.limacore.blockentity.IOAccess;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public interface FluidHandlerIOWrapper
extends IFluidHandler {
    public static FluidHandlerIOWrapper of(IFluidHandler handler, IOAccess access) {
        return new SimpleWrapper(handler, access);
    }

    public IFluidHandler fluidHandler();

    default public int getTanks() {
        return this.fluidHandler().getTanks();
    }

    default public FluidStack getFluidInTank(int tank) {
        return this.fluidHandler().getFluidInTank(tank);
    }

    default public int getTankCapacity(int tank) {
        return this.fluidHandler().getTankCapacity(tank);
    }

    default public boolean isFluidValid(int tank, FluidStack stack) {
        return this.fluidHandler().isFluidValid(tank, stack);
    }

    public record SimpleWrapper(IFluidHandler fluidHandler, IOAccess access) implements FluidHandlerIOWrapper
    {
        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            return this.access.allowsInput() ? this.fluidHandler.fill(resource, action) : 0;
        }

        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            return this.access.allowsOutput() ? this.fluidHandler.drain(resource, action) : FluidStack.EMPTY;
        }

        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            return this.access.allowsOutput() ? this.fluidHandler.drain(maxDrain, action) : FluidStack.EMPTY;
        }
    }
}

