/*
 * Decompiled with CFR 0.152.
 */
package liedge.limacore.capability.fluid;

import liedge.limacore.blockentity.BlockContentsType;
import liedge.limacore.blockentity.IOAccess;
import liedge.limacore.blockentity.LimaBlockEntityAccess;
import liedge.limacore.capability.fluid.CombinedFluidsWrapper;
import liedge.limacore.capability.fluid.FluidHandlerIOWrapper;
import liedge.limacore.capability.fluid.LimaBlockEntityFluidHandler;
import net.minecraft.core.Direction;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public interface FluidHolderBlockEntity
extends LimaBlockEntityAccess {
    @Nullable
    public LimaBlockEntityFluidHandler getFluidHandler(BlockContentsType var1);

    default public LimaBlockEntityFluidHandler getFluidHandlerOrThrow(BlockContentsType contentsType) {
        LimaBlockEntityFluidHandler handler = this.getFluidHandler(contentsType);
        if (handler != null) {
            return handler;
        }
        throw new IllegalArgumentException("Block entity does not support fluid contents type " + contentsType.getSerializedName());
    }

    public int getBaseFluidCapacity(BlockContentsType var1, int var2);

    public int getBaseFluidTransferRate(BlockContentsType var1, int var2);

    public boolean isValidFluid(BlockContentsType var1, int var2, FluidStack var3);

    public IOAccess getSideIOForFluids(@Nullable Direction var1);

    @ApiStatus.OverrideOnly
    default public IOAccess getFluidTankIO(BlockContentsType contentsType, int tank) {
        return switch (contentsType) {
            default -> throw new MatchException(null, null);
            case BlockContentsType.GENERAL -> IOAccess.INPUT_AND_OUTPUT;
            case BlockContentsType.AUXILIARY -> IOAccess.DISABLED;
            case BlockContentsType.INPUT -> IOAccess.INPUT_ONLY;
            case BlockContentsType.OUTPUT -> IOAccess.OUTPUT_ONLY;
        };
    }

    @ApiStatus.OverrideOnly
    default public void onFluidsChanged(BlockContentsType contentsType, int tank) {
        this.setChanged();
    }

    @Nullable
    public IFluidHandler createFluidIOWrapper(@Nullable Direction var1);

    @ApiStatus.NonExtendable
    @Nullable
    default public IFluidHandler wrapInputOutputTanks(@Nullable Direction side) {
        IOAccess blockAccessLevel = this.getSideIOForFluids(side);
        return switch (blockAccessLevel) {
            default -> throw new MatchException(null, null);
            case IOAccess.DISABLED -> null;
            case IOAccess.INPUT_ONLY -> this.fluidWrapper(BlockContentsType.INPUT, blockAccessLevel);
            case IOAccess.OUTPUT_ONLY -> this.fluidWrapper(BlockContentsType.OUTPUT, blockAccessLevel);
            case IOAccess.INPUT_AND_OUTPUT -> new CombinedFluidsWrapper(this.fluidWrapper(BlockContentsType.INPUT, blockAccessLevel), this.fluidWrapper(BlockContentsType.OUTPUT, blockAccessLevel));
        };
    }

    private FluidHandlerIOWrapper fluidWrapper(BlockContentsType contentsType, IOAccess blockAccessLevel) {
        return this.getFluidHandlerOrThrow(contentsType).createIOWrapper(blockAccessLevel);
    }
}

